/*
 * Decompiled with CFR 0.152.
 */
package cn.snowheart.dingtalk.robot.starter.entity;

import cn.snowheart.dingtalk.robot.starter.entity.BaseMessage;
import cn.snowheart.dingtalk.robot.starter.type.MessageType;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class MarkdownMessage
extends BaseMessage {
    private String text;
    private String title;
    private String[] atMobiles;
    private boolean isAtAll;

    public MarkdownMessage() {
    }

    public MarkdownMessage(String title, String text) {
        this.text = text;
        this.title = title;
    }

    public MarkdownMessage(String title, String text, String[] atMobiles) {
        this.text = text;
        this.title = title;
        this.atMobiles = atMobiles;
    }

    public MarkdownMessage(String title, String text, boolean isAtAll) {
        this.text = text;
        this.title = title;
        this.isAtAll = isAtAll;
    }

    @Override
    public Map toMessageMap() {
        if (StringUtils.isEmpty((Object)this.title) || StringUtils.isEmpty((Object)this.text) || !MessageType.markdown.equals((Object)this.msgtype)) {
            throw new IllegalArgumentException("please check the necessary parameters!");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("msgtype", (Object)this.msgtype);
        HashMap<String, String> markdownItems = new HashMap<String, String>(8);
        markdownItems.put("title", this.title);
        markdownItems.put("text", this.text);
        resultMap.put("markdown", markdownItems);
        HashMap<String, Object> atItems = new HashMap<String, Object>(8);
        atItems.put("atMobiles", this.atMobiles);
        atItems.put("isAtAll", this.isAtAll);
        resultMap.put("at", atItems);
        return resultMap;
    }

    @Override
    protected void init() {
        this.msgtype = MessageType.markdown;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String[] getAtMobiles() {
        return this.atMobiles;
    }

    public void setAtMobiles(String[] atMobiles) {
        this.atMobiles = atMobiles;
    }

    public boolean getIsAtAll() {
        return this.isAtAll;
    }

    public void setIsAtAll(boolean isAtAll) {
    }
}

