/*
 * Decompiled with CFR 0.152.
 */
package cn.snowheart.dingtalk.robot.starter.entity;

import cn.snowheart.dingtalk.robot.starter.entity.BaseMessage;
import cn.snowheart.dingtalk.robot.starter.entity.FeedCardMessageItem;
import cn.snowheart.dingtalk.robot.starter.type.MessageType;
import cn.snowheart.dingtalk.robot.starter.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FeedCardMessage
extends BaseMessage {
    private static final int MAX_BUTTON_COUNT = 10;
    private static final int MIN_BUTTON_COUNT = 1;
    private List<FeedCardMessageItem> feedCardItems = new ArrayList<FeedCardMessageItem>();

    public FeedCardMessage() {
    }

    public FeedCardMessage(List<FeedCardMessageItem> feedCardItems) {
        if (!(feedCardItems instanceof ArrayList)) {
            throw new IllegalArgumentException("feedCardItems must bu ArrayList");
        }
        if (feedCardItems.size() > 10) {
            throw new IllegalArgumentException("the number of buttons is not advise bigger than 10");
        }
        this.feedCardItems = feedCardItems;
    }

    @Override
    protected void init() {
        this.msgtype = MessageType.feedCard;
    }

    @Override
    public Map toMessageMap() {
        if (this.feedCardItems == null || this.feedCardItems.size() < 1) {
            throw new IllegalArgumentException("the number of feedCardItems is not allow lower than 1");
        }
        if (this.feedCardItems.size() > 10) {
            throw new IllegalArgumentException("the number of buttons is not advise bigger than 10");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("msgtype", (Object)this.msgtype);
        HashMap<String, List<FeedCardMessageItem>> feedCardMap = new HashMap<String, List<FeedCardMessageItem>>();
        feedCardMap.put("links", this.feedCardItems);
        resultMap.put("feedCard", feedCardMap);
        return resultMap;
    }

    public List<FeedCardMessageItem> getFeedCardItems() {
        return this.feedCardItems;
    }

    public void addFeedCardItem(FeedCardMessageItem item) {
        if (item == null || StringUtil.isEmpty(item.getMessageURL()) || StringUtil.isEmpty(item.getPicURL()) || StringUtil.isEmpty(item.getTitle())) {
            throw new IllegalArgumentException("please check the necessary parameters of item!");
        }
        if (this.feedCardItems == null || this.feedCardItems.size() >= 10) {
            throw new IllegalArgumentException("the number of buttons is not advise bigger than 10");
        }
        this.feedCardItems.add(item);
    }
}

