/*
 * Decompiled with CFR 0.152.
 */
package cn.snowheart.dingtalk.robot.starter.entity;

import cn.snowheart.dingtalk.robot.starter.entity.ActionCardButton;
import cn.snowheart.dingtalk.robot.starter.entity.BaseMessage;
import cn.snowheart.dingtalk.robot.starter.type.ButtonOrientationType;
import cn.snowheart.dingtalk.robot.starter.type.HideAvatarType;
import cn.snowheart.dingtalk.robot.starter.type.MessageType;
import cn.snowheart.dingtalk.robot.starter.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionCardMessage
extends BaseMessage {
    private static final int MAX_BUTTON_COUNT = 5;
    private static final int MIN_BUTTON_COUNT = 0;
    private String title;
    private String text;
    private HideAvatarType hideAvatar = HideAvatarType.UNHIDE;
    private ButtonOrientationType btnOrientation = ButtonOrientationType.HORIZONTAL;
    private boolean isButtonView;
    private List<ActionCardButton> buttons = new ArrayList<ActionCardButton>();

    public ActionCardMessage() {
    }

    public ActionCardMessage(String title, String text) {
        this.title = title;
        this.text = text;
    }

    public ActionCardMessage(String title, String text, HideAvatarType hideAvatar) {
        this.title = title;
        this.text = text;
        this.hideAvatar = hideAvatar;
    }

    public ActionCardMessage(String title, String text, ActionCardButton button) {
        this.title = title;
        this.text = text;
        this.buttons.add(button);
    }

    public ActionCardMessage(String title, String text, HideAvatarType hideAvatar, ActionCardButton button) {
        this.title = title;
        this.text = text;
        this.hideAvatar = hideAvatar;
        this.buttons.add(button);
    }

    @Override
    protected void init() {
        this.msgtype = MessageType.actionCard;
    }

    @Override
    public Map toMessageMap() {
        if (StringUtil.isEmpty(this.text) || StringUtil.isEmpty(this.title)) {
            throw new IllegalArgumentException("please check the necessary parameters!");
        }
        if (this.buttons == null || this.buttons.size() < 0) {
            throw new IllegalArgumentException("the number of buttons is not allow lower than 0");
        }
        if (this.buttons.size() > 5) {
            throw new IllegalArgumentException("the number of buttons is not advise bigger than 5");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("msgtype", (Object)this.msgtype);
        HashMap<String, Object> actionCardMap = new HashMap<String, Object>();
        actionCardMap.put("title", this.title);
        actionCardMap.put("text", this.text);
        actionCardMap.put("hideAvatar", this.hideAvatar.getValue());
        actionCardMap.put("btnOrientation", this.btnOrientation.getValue());
        if (this.buttons.size() == 1 && !this.isButtonView) {
            actionCardMap.put("singleTitle", this.buttons.get(0).getTitle());
            actionCardMap.put("singleURL", this.buttons.get(0).getActionURL());
        } else if (this.buttons.size() > 1) {
            actionCardMap.put("btns", this.buttons);
        }
        resultMap.put("actionCard", actionCardMap);
        return resultMap;
    }

    public void addButton(ActionCardButton button) {
        if (button == null) {
            throw new IllegalArgumentException("not allow add empty button");
        }
        if (this.buttons == null || this.buttons.size() >= 5) {
            throw new IllegalArgumentException("the number of buttons is not advise bigger than 5");
        }
        this.buttons.add(button);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public HideAvatarType getHideAvatar() {
        return this.hideAvatar;
    }

    public void setHideAvatar(HideAvatarType hideAvatar) {
        this.hideAvatar = hideAvatar;
    }

    public ButtonOrientationType getBtnOrientation() {
        return this.btnOrientation;
    }

    public void setBtnOrientation(ButtonOrientationType btnOrientation) {
        this.btnOrientation = btnOrientation;
    }

    public List<ActionCardButton> getButtons() {
        return this.buttons;
    }

    public boolean isButtonView() {
        return this.isButtonView;
    }

    public void setButtonView(boolean buttonView) {
        this.isButtonView = buttonView;
    }
}

