/*
 * Decompiled with CFR 0.152.
 */
package cn.snowheart.dingtalk.robot.starter.client;

import cn.snowheart.dingtalk.robot.starter.entity.ActionCardButton;
import cn.snowheart.dingtalk.robot.starter.entity.ActionCardMessage;
import cn.snowheart.dingtalk.robot.starter.entity.BaseMessage;
import cn.snowheart.dingtalk.robot.starter.entity.DingTalkResponse;
import cn.snowheart.dingtalk.robot.starter.entity.FeedCardMessage;
import cn.snowheart.dingtalk.robot.starter.entity.FeedCardMessageItem;
import cn.snowheart.dingtalk.robot.starter.entity.LinkMessage;
import cn.snowheart.dingtalk.robot.starter.entity.MarkdownMessage;
import cn.snowheart.dingtalk.robot.starter.entity.TextMessage;
import cn.snowheart.dingtalk.robot.starter.exception.DingTalkException;
import cn.snowheart.dingtalk.robot.starter.type.HideAvatarType;
import cn.snowheart.dingtalk.robot.starter.type.ResponseCodeType;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DingTalkRobotClient {
    @Autowired
    @Qualifier(value="dingTalkRobotRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${dingtalk.robot.prefix:https://oapi.dingtalk.com/robot/send?access_token=}")
    private String DEFAULT_URL_PREFIX;
    @Value(value="${dingtalk.robot.webhook}")
    private String DEFAULT_WEBHOOK;

    public DingTalkResponse sendMessageByURL(String url, BaseMessage message) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)message.toMessageMap(), (MultiValueMap)headers);
        DingTalkResponse dingTalkResponse = (DingTalkResponse)this.restTemplate.postForObject(url, (Object)entity, DingTalkResponse.class, new Object[0]);
        if (!ResponseCodeType.OK.getValue().equals(dingTalkResponse.getErrcode())) {
            throw new DingTalkException(dingTalkResponse.getErrcode(), dingTalkResponse.getErrmsg());
        }
        return dingTalkResponse;
    }

    public DingTalkResponse sendMessageByAccessToken(String accessToken, BaseMessage message) {
        return this.sendMessageByURL(this.DEFAULT_URL_PREFIX + accessToken, message);
    }

    public DingTalkResponse sendMessage(BaseMessage message) {
        return this.sendMessageByURL(this.DEFAULT_WEBHOOK, message);
    }

    public DingTalkResponse sendTextMessage(TextMessage message) {
        return this.sendMessage(message);
    }

    public DingTalkResponse sendTextMessage(String content) {
        return this.sendMessage(new TextMessage(content));
    }

    public DingTalkResponse sendTextMessage(String content, String[] atMobiles) {
        return this.sendMessage(new TextMessage(content, atMobiles));
    }

    public DingTalkResponse sendTextMessage(String content, boolean isAtAll) {
        return this.sendMessage(new TextMessage(content, isAtAll));
    }

    public DingTalkResponse sendLinkMessage(LinkMessage message) {
        return this.sendMessage(message);
    }

    public DingTalkResponse sendLinkMessage(String title, String text, String messageUrl) {
        return this.sendMessage(new LinkMessage(title, text, messageUrl));
    }

    public DingTalkResponse sendLinkMessage(String title, String text, String messageUrl, String picUrl) {
        return this.sendMessage(new LinkMessage(title, text, messageUrl, picUrl));
    }

    public DingTalkResponse sendMarkdownMessage(MarkdownMessage message) {
        return this.sendMessage(message);
    }

    public DingTalkResponse sendMarkdownMessage(String title, String text) {
        return this.sendMessage(new MarkdownMessage(title, text));
    }

    public DingTalkResponse sendMarkdownMessage(String title, String text, String[] atMobiles) {
        return this.sendMessage(new MarkdownMessage(title, text, atMobiles));
    }

    public DingTalkResponse sendMarkdownMessage(String title, String text, boolean isAtAll) {
        return this.sendMessage(new MarkdownMessage(title, text, isAtAll));
    }

    public DingTalkResponse sendActionCardMessage(ActionCardMessage message) {
        return this.sendMessage(message);
    }

    public DingTalkResponse sendActionCardMessage(String title, String text) {
        return this.sendMessage(new ActionCardMessage(title, text));
    }

    public DingTalkResponse sendActionCardMessage(String title, String text, HideAvatarType hideAvatar) {
        return this.sendMessage(new ActionCardMessage(title, text, hideAvatar));
    }

    public DingTalkResponse sendActionCardMessage(String title, String text, ActionCardButton button) {
        return this.sendMessage(new ActionCardMessage(title, text, button));
    }

    public DingTalkResponse sendActionCardMessage(String title, String text, HideAvatarType hideAvatar, ActionCardButton button) {
        return this.sendMessage(new ActionCardMessage(title, text, hideAvatar, button));
    }

    public DingTalkResponse sendFeedCardMessage(FeedCardMessage feedCardMessage) {
        return this.sendMessage(feedCardMessage);
    }

    public DingTalkResponse sendFeedCardMessage(List<FeedCardMessageItem> feedCardItems) {
        return this.sendMessage(new FeedCardMessage(feedCardItems));
    }
}

