/*
 * Decompiled with CFR 0.152.
 */
package cn.smthit.v4.redis.id;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class BusinessNoGenerator {
    private static final Logger log = LoggerFactory.getLogger(BusinessNoGenerator.class);
    @Autowired
    private RedisTemplate redisTemplate;

    public String generate(String businessNoPrefix, int businessCode, Integer digit) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String date = LocalDateTime.now(ZoneOffset.of("+8")).format(formatter);
        String key = businessNoPrefix + businessCode + ":" + date;
        Long increment = this.redisTemplate.opsForValue().increment((Object)key);
        return date + businessCode + String.format("%0" + digit + "d", increment);
    }

    public String generate(String businessNoPrefix, int businessCode) {
        Integer defaultDigit = 6;
        return this.generate(businessNoPrefix, businessCode, defaultDigit);
    }
}

