/*
 * Decompiled with CFR 0.152.
 */
package cn.smthit.v4.redis;

import cn.hutool.core.util.StrUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(prefix="redisson", name={"address"})
@ConfigurationProperties(prefix="redisson")
@Configuration
public class RedissonConfig {
    private String address;
    private String password;
    private Integer database;
    private Integer minIdle;

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        SingleServerConfig singleServerConfig = config.useSingleServer();
        singleServerConfig.setAddress(this.address);
        singleServerConfig.setDatabase(this.database.intValue());
        singleServerConfig.setConnectionMinimumIdleSize(this.minIdle.intValue());
        if (StrUtil.isNotBlank((CharSequence)this.password)) {
            singleServerConfig.setPassword(this.password);
        }
        return Redisson.create((Config)config);
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(Integer database) {
        this.database = database;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }
}

