/*
 * Decompiled with CFR 0.152.
 */
package cn.smthit.v4.eventbus;

import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmthitLoggingHandler
implements SubscriberExceptionHandler {
    static final SmthitLoggingHandler INSTANCE = new SmthitLoggingHandler();

    public void handleException(Throwable exception, SubscriberExceptionContext context) {
        Logger logger = SmthitLoggingHandler.logger(context);
        logger.error(SmthitLoggingHandler.message(context), exception);
    }

    private static Logger logger(SubscriberExceptionContext context) {
        return LoggerFactory.getLogger((String)(context.getEventBus().getClass().getName() + "." + context.getEventBus().identifier()));
    }

    private static String message(SubscriberExceptionContext context) {
        Method method = context.getSubscriberMethod();
        return "Exception thrown by subscriber method " + method.getName() + '(' + method.getParameterTypes()[0].getName() + ')' + " on subscriber " + context.getSubscriber() + " when dispatching event: " + context.getEvent();
    }
}

