/*
 * Decompiled with CFR 0.152.
 */
package cn.smthit.v4.eventbus;

import cn.smthit.v4.common.lang.exception.ServiceException;
import cn.smthit.v4.eventbus.IDeadEventHandler;
import cn.smthit.v4.eventbus.SmthitDeadEventHandler;
import cn.smthit.v4.eventbus.SmthitLoggingHandler;
import com.google.common.eventbus.DeadEvent;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SmthitAsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.SubscriberExceptionHandler;
import com.google.common.eventbus.SyncEventBus;
import java.text.MessageFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SmthitEventBusFactory {
    private final String SMTHIT_DEFAULT_SYNC_BUS = "SMTHIT_DEFAULT_SYNC_BUS";
    private final String SMTHIT_DEFAULT_ASYNC_BUS = "SMTHIT-DEFAULT-ASYNC-BUS";
    private EventBus defaultSyncEventBus;
    private EventBus defaultAsyncEventBus;
    private ExecutorService asyncThreadPoolExecutor;
    private SubscriberExceptionHandler exceptionHandler = SmthitLoggingHandler.INSTANCE;
    private IDeadEventHandler deadEventHandler = new SmthitDeadEventHandler();
    private int asycThreadPoolSize = 10;

    public void init() {
        this.asyncThreadPoolExecutor = Executors.newFixedThreadPool(this.asycThreadPoolSize);
        this.defaultSyncEventBus = new SyncEventBus("SMTHIT_DEFAULT_SYNC_BUS", this.exceptionHandler);
        this.defaultAsyncEventBus = new SmthitAsyncEventBus("SMTHIT-DEFAULT-ASYNC-BUS", this.asyncThreadPoolExecutor, this.exceptionHandler);
        this.defaultSyncEventBus.register((Object)this);
        this.defaultAsyncEventBus.register((Object)this);
    }

    @Subscribe
    public void listen(DeadEvent deadEvent) {
        if (this.deadEventHandler != null) {
            this.deadEventHandler.handle(deadEvent);
        }
    }

    public void destroy() {
        this.defaultSyncEventBus.unregister((Object)this);
        this.defaultAsyncEventBus.unregister((Object)this);
    }

    public void registerSyncEventBus(Object listener) {
        this.defaultSyncEventBus.register(listener);
    }

    public void registerAsyncEventBus(Object listener) {
        this.defaultAsyncEventBus.register(listener);
    }

    public void registerEventBus(String eventBusName, Object listener) {
        if ("SMTHIT_DEFAULT_SYNC_BUS".equalsIgnoreCase(eventBusName)) {
            this.defaultSyncEventBus.register(listener);
            return;
        }
        if ("SMTHIT-DEFAULT-ASYNC-BUS".equalsIgnoreCase(eventBusName)) {
            this.defaultAsyncEventBus.register((Object)this);
            return;
        }
        throw new ServiceException(MessageFormat.format("{0}\u6d88\u606f\u4e2d\u7ebf\u4e0d\u5b58\u5728", eventBusName));
    }

    public void unregisterSyncEventBus(Object listener) {
        this.defaultSyncEventBus.unregister(listener);
    }

    public void unregisterAsyncEventBus(Object listener) {
        this.defaultAsyncEventBus.unregister(listener);
    }

    public void unregisterEventBus(String eventBusName, Object listener) {
        if ("SMTHIT_DEFAULT_SYNC_BUS".equalsIgnoreCase(eventBusName)) {
            this.defaultSyncEventBus.unregister(listener);
            return;
        }
        if ("SMTHIT-DEFAULT-ASYNC-BUS".equalsIgnoreCase(eventBusName)) {
            this.defaultAsyncEventBus.unregister(listener);
            return;
        }
        throw new ServiceException(MessageFormat.format("{0}\u6d88\u606f\u4e2d\u7ebf\u4e0d\u5b58\u5728", eventBusName));
    }

    public EventBus getDefaultEventBus() {
        return this.defaultSyncEventBus;
    }

    public EventBus getDefaultAsyncEventBus() {
        return this.defaultAsyncEventBus;
    }

    public EventBus getEventBus(String eventBusName) {
        if ("SMTHIT_DEFAULT_SYNC_BUS".equalsIgnoreCase(eventBusName)) {
            return this.defaultSyncEventBus;
        }
        if ("SMTHIT-DEFAULT-ASYNC-BUS".equalsIgnoreCase(eventBusName)) {
            return this.defaultAsyncEventBus;
        }
        throw new ServiceException(MessageFormat.format("{0}\u6d88\u606f\u4e2d\u7ebf\u4e0d\u5b58\u5728", eventBusName));
    }

    public void setDeadEventHandler(IDeadEventHandler deadEventHandler) {
        this.deadEventHandler = deadEventHandler;
    }

    public void setAsycThreadPoolSize(int asycThreadPoolSize) {
        this.asycThreadPoolSize = asycThreadPoolSize;
    }
}

