/*
 * Decompiled with CFR 0.152.
 */
package cn.smilevers.xxljob.spring.boot.autoconfigure;

import cn.smilevers.xxljob.spring.boot.autoconfigure.XxljobProperties;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={XxljobProperties.class})
@ConditionalOnProperty(prefix="xxl.job", name={"admin", "executor"}, matchIfMissing=true)
public class XxlJobConfig {
    public static Logger logger = LoggerFactory.getLogger(XxlJobConfig.class);
    private XxljobProperties xxljobProperties;

    public XxlJobConfig(XxljobProperties xxljobProperties) {
        this.xxljobProperties = xxljobProperties;
    }

    @Bean
    public XxlJobSpringExecutor xxlJobExecutor() {
        logger.info(">>>>>>>>>>> xxl-job config init.");
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        xxlJobSpringExecutor.setAdminAddresses(this.xxljobProperties.getAdmin().getAddresses());
        xxlJobSpringExecutor.setAppname(this.xxljobProperties.getExecutor().getAppName());
        xxlJobSpringExecutor.setAddress(this.xxljobProperties.getExecutor().getAddress());
        xxlJobSpringExecutor.setIp(this.xxljobProperties.getExecutor().getIp());
        xxlJobSpringExecutor.setPort(Integer.valueOf(this.xxljobProperties.getExecutor().getPort()).intValue());
        xxlJobSpringExecutor.setAccessToken(this.xxljobProperties.getAccessToken());
        xxlJobSpringExecutor.setLogPath(this.xxljobProperties.getExecutor().getLogPath());
        xxlJobSpringExecutor.setLogRetentionDays(this.xxljobProperties.getExecutor().getLogretentiondays().intValue());
        return xxlJobSpringExecutor;
    }
}

