/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.vision.utils;

import ai.djl.modality.Classifications;
import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.DetectedObjects;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public class DetectedObjectsFilter {
    private List<String> allowedClasses;
    private float threshold;
    private int topK;

    public DetectedObjectsFilter(List<String> allowedClasses, float threshold) {
        this.allowedClasses = allowedClasses != null ? new ArrayList<String>(allowedClasses) : null;
        this.threshold = threshold;
    }

    public DetectedObjectsFilter(List<String> allowedClasses, float threshold, int topK) {
        this.allowedClasses = allowedClasses;
        this.threshold = threshold;
        this.topK = topK;
    }

    public DetectedObjects filter(DetectedObjects detectedObjects) {
        if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
            return detectedObjects;
        }
        List items = detectedObjects.items();
        List<DetectedObjects.DetectedObject> filtered = new ArrayList();
        if (!CollectionUtils.isEmpty(this.allowedClasses)) {
            for (DetectedObjects.DetectedObject obj : items) {
                if (!this.allowedClasses.contains(obj.getClassName())) continue;
                filtered.add(obj);
            }
        } else {
            filtered = items;
        }
        if (this.topK > 0 && filtered.size() > this.topK) {
            filtered.sort(Comparator.comparingDouble(Classifications.Classification::getProbability).reversed());
            filtered = filtered.subList(0, this.topK);
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Double> probs = new ArrayList<Double>();
        ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
        for (DetectedObjects.DetectedObject obj : filtered) {
            names.add(obj.getClassName());
            probs.add(obj.getProbability());
            boxes.add(obj.getBoundingBox());
        }
        return new DetectedObjects(names, probs, boxes);
    }

    public List<String> getAllowedClasses() {
        return this.allowedClasses;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public int getTopK() {
        return this.topK;
    }

    public void setAllowedClasses(List<String> allowedClasses) {
        this.allowedClasses = allowedClasses;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public void setTopK(int topK) {
        this.topK = topK;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetectedObjectsFilter)) {
            return false;
        }
        DetectedObjectsFilter other = (DetectedObjectsFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$allowedClasses = this.getAllowedClasses();
        List<String> other$allowedClasses = other.getAllowedClasses();
        if (this$allowedClasses == null ? other$allowedClasses != null : !((Object)this$allowedClasses).equals(other$allowedClasses)) {
            return false;
        }
        if (Float.compare(this.getThreshold(), other.getThreshold()) != 0) {
            return false;
        }
        return this.getTopK() == other.getTopK();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DetectedObjectsFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $allowedClasses = this.getAllowedClasses();
        result = result * 59 + ($allowedClasses == null ? 43 : ((Object)$allowedClasses).hashCode());
        result = result * 59 + Float.floatToIntBits(this.getThreshold());
        result = result * 59 + this.getTopK();
        return result;
    }

    public String toString() {
        return "DetectedObjectsFilter(allowedClasses=" + this.getAllowedClasses() + ", threshold=" + this.getThreshold() + ", topK=" + this.getTopK() + ")";
    }
}

