/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.vision.utils;

import ai.djl.modality.Classifications;
import java.util.ArrayList;
import java.util.List;

public class ClassificationFilter {
    private List<String> allowedClasses;
    private float threshold;

    public ClassificationFilter(List<String> allowedClasses, float threshold) {
        this.allowedClasses = allowedClasses != null ? new ArrayList<String>(allowedClasses) : null;
        this.threshold = threshold;
    }

    public Classifications filter(Classifications classifications) {
        List originalClasses = classifications.getClassNames();
        List originalProbabilities = classifications.getProbabilities();
        ArrayList<String> filteredClasses = new ArrayList<String>();
        ArrayList<Double> filteredProbabilities = new ArrayList<Double>();
        for (int i = 0; i < originalClasses.size(); ++i) {
            String className = (String)originalClasses.get(i);
            double probability = (Double)originalProbabilities.get(i);
            if (!(probability >= (double)this.threshold) || this.allowedClasses != null && !this.allowedClasses.contains(className)) continue;
            filteredClasses.add(className);
            filteredProbabilities.add(probability);
        }
        return new Classifications(filteredClasses, filteredProbabilities);
    }

    public List<String> getAllowedClasses() {
        return this.allowedClasses;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setAllowedClasses(List<String> allowedClasses) {
        this.allowedClasses = allowedClasses;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassificationFilter)) {
            return false;
        }
        ClassificationFilter other = (ClassificationFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$allowedClasses = this.getAllowedClasses();
        List<String> other$allowedClasses = other.getAllowedClasses();
        if (this$allowedClasses == null ? other$allowedClasses != null : !((Object)this$allowedClasses).equals(other$allowedClasses)) {
            return false;
        }
        return Float.compare(this.getThreshold(), other.getThreshold()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassificationFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $allowedClasses = this.getAllowedClasses();
        result = result * 59 + ($allowedClasses == null ? 43 : ((Object)$allowedClasses).hashCode());
        result = result * 59 + Float.floatToIntBits(this.getThreshold());
        return result;
    }

    public String toString() {
        return "ClassificationFilter(allowedClasses=" + this.getAllowedClasses() + ", threshold=" + this.getThreshold() + ")";
    }
}

