/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.vision.utils;

import ai.djl.modality.cv.output.CategoryMask;
import java.util.ArrayList;
import java.util.List;

public class CategoryMaskFilter {
    private List<String> allowedClasses;

    public CategoryMaskFilter(List<String> allowedClasses) {
        this.allowedClasses = allowedClasses != null ? new ArrayList<String>(allowedClasses) : null;
    }

    public CategoryMask filter(CategoryMask categoryMask) {
        if (categoryMask == null) {
            throw new NullPointerException("Input categoryMask cannot be null");
        }
        if (this.allowedClasses == null) {
            ArrayList classNamesCopy = new ArrayList(categoryMask.getClasses());
            int[][] maskCopy = this.copyMask(categoryMask.getMask());
            return new CategoryMask(classNamesCopy, maskCopy);
        }
        List originalClassNames = categoryMask.getClasses();
        int[][] originalMask = categoryMask.getMask();
        ArrayList<String> filteredClassNames = new ArrayList<String>();
        ArrayList<Integer> allowedOriginalIndices = new ArrayList<Integer>();
        for (int i = 0; i < originalClassNames.size(); ++i) {
            String className = (String)originalClassNames.get(i);
            if (!this.allowedClasses.contains(className)) continue;
            filteredClassNames.add(className);
            allowedOriginalIndices.add(i);
        }
        int height = originalMask.length;
        int width = height > 0 ? originalMask[0].length : 0;
        int[][] filteredMask = new int[height][width];
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                int originalIndex = originalMask[h][w];
                int newIndex = allowedOriginalIndices.indexOf(originalIndex);
                filteredMask[h][w] = newIndex != -1 ? newIndex : 0;
            }
        }
        return new CategoryMask(filteredClassNames, filteredMask);
    }

    private int[][] copyMask(int[][] originalMask) {
        int height = originalMask.length;
        int width = height > 0 ? originalMask[0].length : 0;
        int[][] copy = new int[height][width];
        for (int h = 0; h < height; ++h) {
            System.arraycopy(originalMask[h], 0, copy[h], 0, width);
        }
        return copy;
    }

    public List<String> getAllowedClasses() {
        return this.allowedClasses;
    }

    public void setAllowedClasses(List<String> allowedClasses) {
        this.allowedClasses = allowedClasses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoryMaskFilter)) {
            return false;
        }
        CategoryMaskFilter other = (CategoryMaskFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$allowedClasses = this.getAllowedClasses();
        List<String> other$allowedClasses = other.getAllowedClasses();
        return !(this$allowedClasses == null ? other$allowedClasses != null : !((Object)this$allowedClasses).equals(other$allowedClasses));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CategoryMaskFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $allowedClasses = this.getAllowedClasses();
        result = result * 59 + ($allowedClasses == null ? 43 : ((Object)$allowedClasses).hashCode());
        return result;
    }

    public String toString() {
        return "CategoryMaskFilter(allowedClasses=" + this.getAllowedClasses() + ")";
    }
}

