/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.semseg.model;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import cn.smartjavaai.semseg.config.SemSegModelConfig;
import cn.smartjavaai.semseg.enums.SemSegModelEnum;
import cn.smartjavaai.semseg.model.CommonSemSegModel;
import cn.smartjavaai.semseg.model.SemSegModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemSegModelFactory {
    private static final Logger log = LoggerFactory.getLogger(SemSegModelFactory.class);
    private static volatile SemSegModelFactory instance;
    private static final ConcurrentHashMap<SemSegModelEnum, SemSegModel> modelMap;
    private static final Map<SemSegModelEnum, Class<? extends SemSegModel>> registry;

    private SemSegModelFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SemSegModelFactory getInstance() {
        if (instance != null) return instance;
        Class<SemSegModelFactory> clazz = SemSegModelFactory.class;
        synchronized (SemSegModelFactory.class) {
            if (instance != null) return instance;
            instance = new SemSegModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public SemSegModel getModel(SemSegModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceDetModel(config));
    }

    private SemSegModel createFaceDetModel(SemSegModelConfig config) {
        Class<? extends SemSegModel> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new DetectionException("Unsupported model");
        }
        SemSegModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DetectionException(e);
        }
        model.loadModel(config);
        model.setFromFactory(true);
        return model;
    }

    private static void registerAlgorithm(SemSegModelEnum modelEnum, Class<? extends SemSegModel> clazz) {
        registry.put(modelEnum, clazz);
    }

    public static void removeFromCache(SemSegModelEnum modelEnum) {
        modelMap.remove((Object)modelEnum);
    }

    public void closeAll() {
        modelMap.values().forEach(model -> {
            try {
                model.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        modelMap.clear();
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<SemSegModelEnum, Class<? extends SemSegModel>>();
        SemSegModelFactory.registerAlgorithm(SemSegModelEnum.DEEPLABV3, CommonSemSegModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

