/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.semseg.model;

import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.CategoryMask;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import cn.smartjavaai.common.cv.SmartImageFactory;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.instanceseg.exception.InstanceSegException;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import cn.smartjavaai.semseg.config.SemSegModelConfig;
import cn.smartjavaai.semseg.criteria.SemSegCriteriaFactory;
import cn.smartjavaai.semseg.model.SemSegModel;
import cn.smartjavaai.semseg.model.SemSegModelFactory;
import cn.smartjavaai.vision.utils.CategoryMaskFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonSemSegModel
implements SemSegModel {
    private static final Logger log = LoggerFactory.getLogger(CommonSemSegModel.class);
    private SemSegModelConfig config;
    private ZooModel<Image, CategoryMask> model;
    private GenericObjectPool<Predictor<Image, CategoryMask>> predictorPool;
    private boolean fromFactory = false;

    @Override
    public void loadModel(SemSegModelConfig config) {
        if (Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b\u679a\u4e3e");
        }
        Criteria<Image, CategoryMask> criteria = SemSegCriteriaFactory.createCriteria(config);
        this.config = config;
        try {
            this.model = criteria.loadModel();
            this.predictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.model));
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.predictorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u5f53\u524d\u8bbe\u5907: " + this.model.getNDManager().getDevice());
            log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new DetectionException("\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    @Override
    public R<CategoryMask> detect(Image image) {
        CategoryMask categoryMask = this.detectCore(image);
        if (CollectionUtils.isNotEmpty(this.config.getAllowedClasses()) && Objects.nonNull(categoryMask) && CollectionUtils.isNotEmpty((Collection)categoryMask.getClasses())) {
            categoryMask = new CategoryMaskFilter(this.config.getAllowedClasses()).filter(categoryMask);
        }
        return R.ok((Object)categoryMask);
    }

    public CategoryMask detectCore(Image image) {
        Predictor predictor = null;
        try {
            predictor = (Predictor)this.predictorPool.borrowObject();
            CategoryMask categoryMask = (CategoryMask)predictor.predict((Object)image);
            return categoryMask;
        }
        catch (Exception e) {
            throw new DetectionException("\u8bed\u4e49\u5206\u5272\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.predictorPool.returnObject((Object)predictor);
                    log.debug("\u91ca\u653e\u8d44\u6e90");
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    try {
                        predictor.close();
                    }
                    catch (Exception ex) {
                        log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public R<CategoryMask> detectAndDraw(String imagePath, String outputPath) {
        try {
            Image img = SmartImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            CategoryMask categoryMask = this.detectCore(img);
            if (Objects.isNull(categoryMask) || CollectionUtils.isEmpty((Collection)categoryMask.getClasses())) {
                throw new InstanceSegException("\u672a\u68c0\u6d4b\u5230\u5b9e\u4f8b");
            }
            ImageUtils.drawMask((CategoryMask)categoryMask, (Image)img, (int)180, (int)0);
            img.save(Files.newOutputStream(Paths.get(outputPath, new String[0]), new OpenOption[0]), "png");
            ImageUtils.releaseOpenCVMat((Image)img);
            return R.ok((Object)categoryMask);
        }
        catch (IOException e) {
            throw new InstanceSegException(e);
        }
    }

    @Override
    public Image detectAndDraw(Image image) {
        CategoryMask categoryMask = this.detectCore(image);
        if (Objects.isNull(categoryMask) || CollectionUtils.isEmpty((Collection)categoryMask.getClasses())) {
            throw new InstanceSegException("\u672a\u68c0\u6d4b\u5230\u5b9e\u4f8b");
        }
        Image drawnImage = ImageUtils.copy((Image)image);
        ImageUtils.drawMask((CategoryMask)categoryMask, (Image)drawnImage, (int)180, (int)0);
        return drawnImage;
    }

    @Override
    public void close() throws Exception {
        if (this.fromFactory) {
            SemSegModelFactory.removeFromCache(this.config.getModelEnum());
        }
        try {
            if (this.predictorPool != null) {
                this.predictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.model != null) {
                this.model.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void setFromFactory(boolean fromFactory) {
        this.fromFactory = fromFactory;
    }

    public boolean isFromFactory() {
        return this.fromFactory;
    }
}

