/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.pose.model;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import cn.smartjavaai.pose.config.PoseModelConfig;
import cn.smartjavaai.pose.enums.PoseModelEnum;
import cn.smartjavaai.pose.model.CommonPoseModel;
import cn.smartjavaai.pose.model.PoseModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoseDetModelFactory {
    private static final Logger log = LoggerFactory.getLogger(PoseDetModelFactory.class);
    private static volatile PoseDetModelFactory instance;
    private static final ConcurrentHashMap<PoseModelEnum, PoseModel> modelMap;
    private static final Map<PoseModelEnum, Class<? extends PoseModel>> registry;

    private PoseDetModelFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PoseDetModelFactory getInstance() {
        if (instance != null) return instance;
        Class<PoseDetModelFactory> clazz = PoseDetModelFactory.class;
        synchronized (PoseDetModelFactory.class) {
            if (instance != null) return instance;
            instance = new PoseDetModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public PoseModel getModel(PoseModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceDetModel(config));
    }

    private PoseModel createFaceDetModel(PoseModelConfig config) {
        Class<? extends PoseModel> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new DetectionException("Unsupported model");
        }
        PoseModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DetectionException(e);
        }
        model.loadModel(config);
        model.setFromFactory(true);
        return model;
    }

    private static void registerAlgorithm(PoseModelEnum modelEnum, Class<? extends PoseModel> clazz) {
        registry.put(modelEnum, clazz);
    }

    public static void removeFromCache(PoseModelEnum modelEnum) {
        modelMap.remove((Object)modelEnum);
    }

    public void closeAll() {
        modelMap.values().forEach(model -> {
            try {
                model.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        modelMap.clear();
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<PoseModelEnum, Class<? extends PoseModel>>();
        PoseDetModelFactory.registerAlgorithm(PoseModelEnum.YOLOV8N_POSE_ONNX, CommonPoseModel.class);
        PoseDetModelFactory.registerAlgorithm(PoseModelEnum.YOLO11N_POSE_ONNX, CommonPoseModel.class);
        PoseDetModelFactory.registerAlgorithm(PoseModelEnum.YOLOV8N_POSE_PT, CommonPoseModel.class);
        PoseDetModelFactory.registerAlgorithm(PoseModelEnum.YOLO11N_POSE_PT, CommonPoseModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

