/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.pose.criteria;

import ai.djl.Device;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.Joints;
import ai.djl.modality.cv.translator.YoloPoseTranslatorFactory;
import ai.djl.repository.zoo.Criteria;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Progress;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.pose.config.PoseModelConfig;
import cn.smartjavaai.pose.enums.PoseModelEnum;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PoseCriteriaFactory {
    public static Criteria<Image, Joints[]> createCriteria(PoseModelConfig config) {
        Device device = null;
        if (!Objects.isNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
        }
        Criteria<Image, Joints[]> criteria = null;
        if (StringUtils.isNotBlank((CharSequence)config.getModelEnum().getModelUri())) {
            criteria = PoseCriteriaFactory.createDJLCriteria(config, device);
        }
        return criteria;
    }

    public static Criteria<Image, Joints[]> createDJLCriteria(PoseModelConfig config, Device device) {
        Criteria criteria = null;
        if (config.getModelEnum() == PoseModelEnum.YOLO11N_POSE_PT || config.getModelEnum() == PoseModelEnum.YOLO11N_POSE_ONNX || config.getModelEnum() == PoseModelEnum.YOLOV8N_POSE_PT || config.getModelEnum() == PoseModelEnum.YOLOV8N_POSE_ONNX) {
            criteria = Criteria.builder().setTypes(Image.class, Joints[].class).optModelUrls(StringUtils.isNotBlank((CharSequence)config.getModelPath()) ? null : config.getModelEnum().getModelUri()).optModelPath(StringUtils.isNotBlank((CharSequence)config.getModelPath()) ? Paths.get(config.getModelPath(), new String[0]) : null).optDevice(device).optTranslatorFactory((TranslatorFactory)new YoloPoseTranslatorFactory()).optArgument("threshold", config.getThreshold() > 0.0f ? Float.valueOf(config.getThreshold()) : null).optProgress((Progress)new ProgressBar()).build();
        }
        return criteria;
    }
}

