/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.objectdetection.stream;

import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import cn.smartjavaai.common.cv.SmartImageFactory;
import cn.smartjavaai.common.entity.DetectionInfo;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.enums.VideoSourceType;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import cn.smartjavaai.objectdetection.model.DetectorModel;
import cn.smartjavaai.objectdetection.stream.StreamDetectionListener;
import cn.smartjavaai.vision.utils.DetectorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import nu.pattern.OpenCV;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.javacv.OpenCVFrameGrabber;
import org.opencv.core.Mat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamDetector
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StreamDetector.class);
    private DetectorModel detectorModel;
    private String streamUrl;
    private ExecutorService grabberExecutor;
    private ExecutorService processorExecutor;
    ExecutorService callbackExecutor;
    private int frameDetectionInterval = 1;
    private long repeatGap = 5L;
    private volatile boolean isRunning;
    private FrameGrabber grabber;
    private StreamDetectionListener listener;
    private OpenCVFrameConverter.ToOrgOpenCvCoreMat converterToMat;
    private VideoSourceType sourceType = VideoSourceType.STREAM;
    private int cameraIndex = 0;
    private Map<String, Long> lastDetectTime = new ConcurrentHashMap<String, Long>();
    private BlockingQueue<Frame> frameQueue = new LinkedBlockingQueue<Frame>(100);
    private GenericObjectPool<Predictor<Image, DetectedObjects>> predictorPool;
    private Predictor<Image, DetectedObjects> predictor;
    boolean grabberFinished = false;
    private int nullFrameCount = 0;
    private static final int MAX_NULL_FRAMES = 10;

    public static Builder builder() {
        return new Builder();
    }

    private StreamDetector(Builder builder) {
        this.detectorModel = builder.detectorModel;
        this.streamUrl = builder.streamUrl;
        this.frameDetectionInterval = builder.frameDetectionInterval;
        this.listener = builder.listener;
        this.sourceType = builder.sourceType;
        this.cameraIndex = builder.cameraIndex;
        this.repeatGap = builder.repeatGap;
        this.converterToMat = new OpenCVFrameConverter.ToOrgOpenCvCoreMat();
    }

    private void initializeGrabber() throws FrameGrabber.Exception {
        if (this.sourceType == VideoSourceType.CAMERA) {
            this.grabber = new OpenCVFrameGrabber(this.cameraIndex);
        } else {
            this.grabber = new FFmpegFrameGrabber(this.streamUrl);
            if (this.sourceType == VideoSourceType.STREAM) {
                this.grabber.setOption("rtsp_transport", "tcp");
                this.grabber.setOption("buffer_size", "1024000");
                this.grabber.setOption("stimeout", "2000000");
                this.grabber.setOption("rw_timeout", "2000000");
                this.grabber.setOption("max_delay", "5000000");
                this.grabber.setOption("timeout", "2000000");
            }
        }
        avutil.av_log_set_level((int)16);
        this.grabber.start();
        if (this.sourceType == VideoSourceType.FILE) {
            int totalFrames = this.grabber.getLengthInFrames();
            log.info("\u89c6\u9891\u5e27\u6570\uff1a{}", (Object)totalFrames);
        }
    }

    public void startDetection() {
        if (this.isRunning) {
            throw new RuntimeException("\u5f53\u524d\u6b63\u5728\u8fd0\u884c\u4e2d");
        }
        this.grabberFinished = false;
        this.predictorPool = this.detectorModel.getPool();
        try {
            this.predictor = (Predictor)this.predictorPool.borrowObject();
        }
        catch (Exception e) {
            throw new DetectionException(e);
        }
        if (this.grabberExecutor == null || this.grabberExecutor.isShutdown()) {
            this.grabberExecutor = Executors.newFixedThreadPool(2);
        }
        if (this.processorExecutor == null || this.processorExecutor.isShutdown()) {
            this.processorExecutor = Executors.newFixedThreadPool(2);
        }
        if (this.callbackExecutor == null || this.callbackExecutor.isShutdown()) {
            this.callbackExecutor = Executors.newFixedThreadPool(4);
        }
        try {
            this.initializeGrabber();
        }
        catch (FrameGrabber.Exception e) {
            throw new DetectionException("\u89c6\u9891\u6d41\u68c0\u6d4b\u542f\u52a8\u5931\u8d25", e);
        }
        this.isRunning = true;
        log.debug("\u89c6\u9891\u6d41\u5904\u7406\u5df2\u542f\u52a8");
        this.grabberExecutor.submit(() -> {
            try {
                this.processFrames();
            }
            catch (Exception e) {
                log.error("\u89c6\u9891\u6d41\u5904\u7406\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.grabberFinished = true;
            }
        });
        this.startFrameProcessor();
    }

    private void processFrames() {
        long frameCount = 0L;
        while (!this.grabberFinished && this.isRunning) {
            try {
                Frame frame = this.grabber.grabFrame();
                if (frame == null) {
                    if (this.sourceType == VideoSourceType.FILE) {
                        log.debug("\u89c6\u9891\u68c0\u6d4b\u7ed3\u675f");
                        this.grabberFinished = true;
                        break;
                    }
                    log.debug("\u672a\u68c0\u6d4b\u5230\u89c6\u9891\u5e27");
                    ++this.nullFrameCount;
                    if (this.nullFrameCount <= 10) continue;
                    log.warn("\u68c0\u6d4b\u5230\u89c6\u9891\u65ad\u5f00\uff0c\u5df2\u8d85\u8fc7\u6700\u5927\u7a7a\u5e27\u6b21\u6570");
                    if (this.isRunning) {
                        this.stopDetection();
                    }
                    if (this.listener == null) break;
                    this.listener.onStreamDisconnected();
                    break;
                }
                this.nullFrameCount = 0;
                if (frame.type != Frame.Type.VIDEO || ++frameCount % (long)this.frameDetectionInterval != 0L) continue;
                Frame currentFrame = frame.clone();
                this.frameQueue.offer(currentFrame);
            }
            catch (Exception e) {
                log.error("\u6293\u53d6\u89c6\u9891\u5e27\u5f02\u5e38", (Throwable)e);
            }
        }
        log.debug("\u6293\u53d6\u5e27\u7ebf\u7a0b\u9000\u51fa");
    }

    private void startFrameProcessor() {
        this.processorExecutor.submit(() -> {
            log.debug("\u5e27\u5904\u7406\u7ebf\u7a0b\u5df2\u542f\u52a8");
            while (!(this.grabberFinished && this.frameQueue.isEmpty() || !this.isRunning)) {
                try {
                    Frame frame = this.frameQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (frame == null) continue;
                    this.processFrame(frame);
                }
                catch (InterruptedException e) {
                    log.debug("\u5e27\u5904\u7406\u7ebf\u7a0b\u88ab\u4e2d\u65ad\uff0c\u51c6\u5907\u9000\u51fa");
                    break;
                }
                catch (Exception e) {
                    log.error("\u5e27\u5904\u7406\u5f02\u5e38", (Throwable)e);
                }
            }
            if (this.isRunning) {
                this.stopDetection();
            }
            if (this.listener != null) {
                this.listener.onStreamEnded();
            }
            log.debug("\u5e27\u5904\u7406\u7ebf\u7a0b\u9000\u51fa");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFrame(Frame frame) {
        Mat mat = null;
        try {
            mat = this.converterToMat.convert(frame);
            if (mat == null) {
                return;
            }
            Image image = SmartImageFactory.getInstance().fromMat(mat);
            DetectedObjects detectedObjects = (DetectedObjects)this.predictor.predict((Object)image);
            DetectionResponse detectionResponse = DetectorUtils.convertToDetectionResponse(detectedObjects, image);
            if (Objects.isNull(detectionResponse)) {
                return;
            }
            List<DetectionInfo> filtered = this.filterRepeatedObjects(detectionResponse);
            if (!filtered.isEmpty() && this.listener != null) {
                Image copyImage = image.duplicate();
                this.callbackExecutor.submit(() -> this.listener.onObjectDetected(filtered, copyImage));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("\u5355\u5e27\u5904\u7406\u5f02\u5e38", e);
        }
        finally {
            if (mat != null) {
                mat.release();
            }
        }
    }

    private List<DetectionInfo> filterRepeatedObjects(DetectionResponse response) {
        ArrayList<DetectionInfo> result = new ArrayList<DetectionInfo>();
        long now = System.currentTimeMillis();
        for (DetectionInfo info : response.getDetectionInfoList()) {
            String name = info.getObjectDetInfo().getClassName();
            Long last = this.lastDetectTime.get(name);
            if (last != null && now - last <= this.repeatGap * 1000L) continue;
            this.lastDetectTime.put(name, now);
            result.add(info);
        }
        return result;
    }

    public void startNextVideo(String videoPath) {
        if (!this.grabberFinished) {
            throw new DetectionException("\u5f53\u524d\u89c6\u9891\u672a\u68c0\u6d4b\u7ed3\u675f\uff0c\u8bf7\u5148\u5173\u95ed\u5f53\u524d\u68c0\u6d4b\uff0c\u518d\u5207\u6362\u4e0b\u4e00\u4e2a\u89c6\u9891");
        }
        if (this.sourceType != VideoSourceType.FILE) {
            throw new DetectionException("sourceType\u4e0d\u662f\u6587\u4ef6");
        }
        this.streamUrl = videoPath;
        this.grabberFinished = false;
        this.startDetection();
    }

    public void stopDetection() {
        log.debug("\u505c\u6b62\u68c0\u6d4b\u4e2d...");
        this.isRunning = false;
        this.grabberFinished = true;
        if (this.predictor != null && this.predictorPool != null) {
            try {
                this.predictorPool.returnObject(this.predictor);
                this.predictor = null;
                this.predictorPool = null;
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                try {
                    this.predictor.close();
                }
                catch (Exception ex) {
                    log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                }
            }
        }
        if (this.grabber != null) {
            try {
                this.grabber.stop();
                this.grabber.release();
                this.grabber = null;
            }
            catch (FrameGrabber.Exception e) {
                log.error("\u91ca\u653eGrabber\u5931\u8d25", (Throwable)e);
            }
        }
        log.debug("\u505c\u6b62\u68c0\u6d4b\u5b8c\u6bd5");
    }

    @Override
    public void close() {
        if (this.grabberExecutor != null) {
            this.grabberExecutor.shutdownNow();
        }
        if (this.processorExecutor != null) {
            this.processorExecutor.shutdownNow();
        }
        if (this.callbackExecutor != null) {
            this.callbackExecutor.shutdownNow();
        }
    }

    static {
        OpenCV.loadLocally();
    }

    public static class Builder {
        private DetectorModel detectorModel;
        private String streamUrl;
        private int frameDetectionInterval = 1;
        private StreamDetectionListener listener;
        private VideoSourceType sourceType = VideoSourceType.STREAM;
        private int cameraIndex = 0;
        private long repeatGap = 5L;

        public Builder detectorModel(DetectorModel m) {
            this.detectorModel = m;
            return this;
        }

        public Builder streamUrl(String url) {
            this.streamUrl = url;
            return this;
        }

        public Builder listener(StreamDetectionListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder repeatGap(long repeatGap) {
            this.repeatGap = repeatGap;
            return this;
        }

        public Builder sourceType(VideoSourceType sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder cameraIndex(int cameraIndex) {
            this.cameraIndex = cameraIndex;
            return this;
        }

        public Builder frameDetectionInterval(int interval) {
            if (interval < 1) {
                throw new IllegalArgumentException("frameDetectionInterval >= 1");
            }
            this.frameDetectionInterval = interval;
            return this;
        }

        public StreamDetector build() {
            if (this.detectorModel == null) {
                throw new DetectionException("detectorModel \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (this.sourceType == null) {
                throw new DetectionException("sourceType \u4e0d\u80fd\u4e3a\u7a7a");
            }
            switch (this.sourceType) {
                case STREAM: 
                case FILE: {
                    if (!StringUtils.isBlank((CharSequence)this.streamUrl)) break;
                    throw new DetectionException("streamUrl \u4e0d\u80fd\u4e3a\u7a7a");
                }
                case CAMERA: {
                    if (this.cameraIndex >= 0) break;
                    throw new DetectionException("cameraIndex \u5fc5\u987b >= 0");
                }
                default: {
                    throw new DetectionException("\u4e0d\u652f\u6301\u7684\u89c6\u9891\u6e90\u7c7b\u578b: " + this.sourceType);
                }
            }
            return new StreamDetector(this);
        }
    }
}

