/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.objectdetection.model;

import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import cn.smartjavaai.common.cv.SmartImageFactory;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.utils.BufferedImageUtils;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.objectdetection.config.DetectorModelConfig;
import cn.smartjavaai.objectdetection.criteria.CriteriaBuilderFactory;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import cn.smartjavaai.objectdetection.model.ObjectDetectionModelFactory;
import cn.smartjavaai.vision.utils.DetectedObjectsFilter;
import cn.smartjavaai.vision.utils.DetectorUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectorModel
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(DetectorModel.class);
    private ZooModel<Image, DetectedObjects> model;
    private GenericObjectPool<Predictor<Image, DetectedObjects>> predictorPool;
    private DetectorModelConfig config;
    private boolean fromFactory = false;

    public void setFromFactory(boolean fromFactory) {
        this.fromFactory = fromFactory;
    }

    public boolean isFromFactory() {
        return this.fromFactory;
    }

    public void loadModel(DetectorModelConfig config) {
        if (Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b\u679a\u4e3e");
        }
        Criteria<Image, DetectedObjects> criteria = CriteriaBuilderFactory.createCriteria(config);
        this.config = config;
        try {
            this.model = criteria.loadModel();
            this.predictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.model));
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.predictorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u5f53\u524d\u8bbe\u5907: " + this.model.getNDManager().getDevice());
            log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new DetectionException("\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    @Deprecated
    public DetectionResponse detect(String imagePath) {
        DetectionResponse detectionResponse;
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new DetectionException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        Image image = null;
        try {
            image = SmartImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            DetectedObjects detectedObjects = this.detectCore(image);
            detectionResponse = DetectorUtils.convertToDetectionResponse(detectedObjects, image);
        }
        catch (Exception e) {
            try {
                throw new DetectionException(e);
            }
            catch (Throwable throwable) {
                ImageUtils.releaseOpenCVMat(image);
                throw throwable;
            }
        }
        ImageUtils.releaseOpenCVMat((Image)image);
        return detectionResponse;
    }

    public void detectAndDraw(String imagePath, String outputPath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new DetectionException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        Image img = null;
        try {
            img = SmartImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            DetectedObjects detectedObjects = this.detectCore(img);
            if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
                throw new DetectionException("\u672a\u68c0\u6d4b\u5230\u56fe\u7247\u4e2d\u7684\u7269\u4f53");
            }
            img.drawBoundingBoxes(detectedObjects);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            img.save((OutputStream)new FileOutputStream(Paths.get(outputPath, new String[0]).toAbsolutePath().toString()), "png");
        }
        catch (IOException e) {
            try {
                throw new DetectionException(e);
            }
            catch (Throwable throwable) {
                ImageUtils.releaseOpenCVMat(img);
                throw throwable;
            }
        }
        ImageUtils.releaseOpenCVMat((Image)img);
    }

    @Deprecated
    public DetectionResponse detect(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            throw new DetectionException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
            return this.detect(image);
        }
        catch (IOException e) {
            throw new DetectionException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Deprecated
    public DetectionResponse detect(BufferedImage image) {
        if (!BufferedImageUtils.isImageValid((BufferedImage)image)) {
            throw new DetectionException("\u56fe\u50cf\u65e0\u6548");
        }
        Image img = null;
        try {
            img = SmartImageFactory.getInstance().fromBufferedImage(image);
            DetectedObjects detectedObjects = this.detectCore(img);
            DetectionResponse detectionResponse = DetectorUtils.convertToDetectionResponse(detectedObjects, img);
            return detectionResponse;
        }
        catch (Exception e) {
            throw new DetectionException(e);
        }
        finally {
            ImageUtils.releaseOpenCVMat((Image)img);
        }
    }

    @Deprecated
    public BufferedImage detectAndDraw(BufferedImage sourceImage) {
        if (!BufferedImageUtils.isImageValid((BufferedImage)sourceImage)) {
            throw new DetectionException("\u56fe\u50cf\u65e0\u6548");
        }
        Image img = SmartImageFactory.getInstance().fromBufferedImage(sourceImage);
        DetectedObjects detectedObjects = this.detectCore(img);
        if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
            throw new DetectionException("\u672a\u68c0\u6d4b\u5230\u56fe\u7247\u4e2d\u7684\u7269\u4f53");
        }
        img.drawBoundingBoxes(detectedObjects);
        BufferedImage drawnImage = ImageUtils.toBufferedImage((Image)img);
        ImageUtils.releaseOpenCVMat((Image)img);
        return drawnImage;
    }

    public DetectionResponse detect(Image image) {
        DetectedObjects detectedObjects = this.detectCore(image);
        return DetectorUtils.convertToDetectionResponse(detectedObjects, image);
    }

    public DetectionResponse detectAndDraw(Image image) {
        DetectedObjects detectedObjects = this.detectCore(image);
        if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
            throw new DetectionException("\u672a\u68c0\u6d4b\u5230\u56fe\u7247\u4e2d\u7684\u7269\u4f53");
        }
        Image img = ImageUtils.copy((Image)image);
        DetectionResponse detectionResponse = DetectorUtils.convertToDetectionResponse(detectedObjects, img);
        img.drawBoundingBoxes(detectedObjects);
        detectionResponse.setDrawnImage(img);
        return detectionResponse;
    }

    public DetectedObjects detectCore(Image image) {
        Predictor predictor = null;
        try {
            predictor = (Predictor)this.predictorPool.borrowObject();
            DetectedObjects detectedObjects = (DetectedObjects)predictor.predict((Object)image);
            if (CollectionUtils.isNotEmpty(this.config.getAllowedClasses()) && Objects.nonNull(detectedObjects) && detectedObjects.getNumberOfObjects() > 0) {
                DetectedObjectsFilter detectedObjectsFilter = new DetectedObjectsFilter(this.config.getAllowedClasses(), this.config.getThreshold(), this.config.getTopK());
                detectedObjects = detectedObjectsFilter.filter(detectedObjects);
            }
            DetectedObjects detectedObjects2 = detectedObjects;
            return detectedObjects2;
        }
        catch (Exception e) {
            throw new DetectionException("\u76ee\u6807\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.predictorPool.returnObject((Object)predictor);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    try {
                        predictor.close();
                    }
                    catch (Exception ex) {
                        log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
        }
    }

    public GenericObjectPool<Predictor<Image, DetectedObjects>> getPool() {
        return this.predictorPool;
    }

    @Override
    public void close() {
        if (this.fromFactory) {
            ObjectDetectionModelFactory.removeFromCache(this.config.getModelEnum());
        }
        try {
            if (this.predictorPool != null) {
                this.predictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.model != null) {
                this.model.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }
}

