/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.objectdetection.criteria;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.repository.zoo.Criteria;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.Translator;
import ai.djl.util.Progress;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.objectdetection.config.DetectorModelConfig;
import cn.smartjavaai.objectdetection.criteria.CriteriaBuilderStrategy;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import cn.smartjavaai.objectdetection.translator.TensorflowTranslator;
import cn.smartjavaai.vision.utils.TensorflowSynsetUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Tensorflow2CriteriaBuilder
implements CriteriaBuilderStrategy {
    @Override
    public Criteria<Image, DetectedObjects> buildCriteria(DetectorModelConfig config) {
        Path synset;
        Path modelPath;
        Device device = null;
        if (!Objects.isNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
        }
        Map<String, Object> customParams = this.getDefaultConfig();
        if (config.getCustomParams() != null) {
            customParams.putAll(config.getCustomParams());
        }
        String synsetUrl = (String)customParams.get("synsetUrl");
        String synsetPath = (String)customParams.get("synsetPath");
        String synsetFileName = (String)customParams.get("synsetFileName");
        Map<Integer, String> classes = null;
        if (StringUtils.isNotBlank((CharSequence)synsetUrl)) {
            try {
                classes = TensorflowSynsetUtils.loadSynset(new URL(synsetUrl));
            }
            catch (IOException e) {
                throw new DetectionException("\u52a0\u8f7dsynset\u5f02\u5e38", e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)synsetPath)) {
            try {
                if (!Files.exists(Paths.get(synsetPath, new String[0]), new LinkOption[0])) {
                    throw new DetectionException("synsetPath:" + synsetPath + "\u4e0d\u5b58\u5728");
                }
                classes = TensorflowSynsetUtils.loadSynset(Paths.get(synsetPath, new String[0]));
            }
            catch (IOException e) {
                throw new DetectionException("\u52a0\u8f7dsynset\u5f02\u5e38", e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)synsetFileName)) {
            if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
                throw new DetectionException("\u6307\u5b9asynsetFileName\uff0c\u9700\u540c\u65f6\u6307\u5b9amodelPath");
            }
            try {
                modelPath = Paths.get(config.getModelPath(), new String[0]);
                synset = modelPath.resolve(synsetFileName);
                if (!Files.exists(synset, new LinkOption[0])) {
                    throw new DetectionException(synset.toAbsolutePath().toString() + " \u4e0d\u5b58\u5728");
                }
                classes = TensorflowSynsetUtils.loadSynset(synset);
            }
            catch (IOException e) {
                throw new DetectionException("\u52a0\u8f7dsynset\u5f02\u5e38", e);
            }
        }
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new DetectionException("modelPath is null");
        }
        try {
            modelPath = Paths.get(config.getModelPath(), new String[0]);
            synsetFileName = "mscoco_label_map.pbtxt";
            synset = modelPath.resolve(synsetFileName);
            if (!Files.exists(synset, new LinkOption[0])) {
                throw new DetectionException(synset.toAbsolutePath().toString() + " \u4e0d\u5b58\u5728");
            }
            classes = TensorflowSynsetUtils.loadSynset(synset);
        }
        catch (IOException e) {
            throw new DetectionException("\u52a0\u8f7dsynset\u5f02\u5e38", e);
        }
        customParams.put("classes", classes);
        Criteria.Builder criteriaBuilder = Criteria.builder().optApplication(Application.CV.OBJECT_DETECTION).setTypes(Image.class, DetectedObjects.class).optModelPath(Paths.get(config.getModelPath(), new String[0])).optModelName("saved_model").optEngine("TensorFlow").optDevice(device).optTranslator((Translator)new TensorflowTranslator(customParams)).optProgress((Progress)new ProgressBar());
        if (config.getMaxBox() > 0) {
            criteriaBuilder.optArgument("maxBox", (Object)config.getMaxBox());
        }
        Criteria criteria = criteriaBuilder.build();
        return criteria;
    }

    public Map<String, Object> getDefaultConfig() {
        return new HashMap<String, Object>();
    }
}

