/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.obb.model;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.obb.config.ObbDetModelConfig;
import cn.smartjavaai.obb.enums.ObbDetModelEnum;
import cn.smartjavaai.obb.model.CommonObbDetModel;
import cn.smartjavaai.obb.model.ObbDetModel;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObbDetModelFactory {
    private static final Logger log = LoggerFactory.getLogger(ObbDetModelFactory.class);
    private static volatile ObbDetModelFactory instance;
    private static final ConcurrentHashMap<ObbDetModelEnum, ObbDetModel> modelMap;
    private static final Map<ObbDetModelEnum, Class<? extends ObbDetModel>> registry;

    private ObbDetModelFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObbDetModelFactory getInstance() {
        if (instance != null) return instance;
        Class<ObbDetModelFactory> clazz = ObbDetModelFactory.class;
        synchronized (ObbDetModelFactory.class) {
            if (instance != null) return instance;
            instance = new ObbDetModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ObbDetModel getModel(ObbDetModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceDetModel(config));
    }

    private ObbDetModel createFaceDetModel(ObbDetModelConfig config) {
        Class<? extends ObbDetModel> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new DetectionException("Unsupported model");
        }
        ObbDetModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DetectionException(e);
        }
        model.loadModel(config);
        model.setFromFactory(true);
        return model;
    }

    private static void registerAlgorithm(ObbDetModelEnum modelEnum, Class<? extends ObbDetModel> clazz) {
        registry.put(modelEnum, clazz);
    }

    public static void removeFromCache(ObbDetModelEnum modelEnum) {
        modelMap.remove((Object)modelEnum);
    }

    public void closeAll() {
        modelMap.values().forEach(model -> {
            try {
                model.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        modelMap.clear();
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<ObbDetModelEnum, Class<? extends ObbDetModel>>();
        ObbDetModelFactory.registerAlgorithm(ObbDetModelEnum.YOLOV11, CommonObbDetModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

