/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.obb.model;

import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import cn.smartjavaai.common.cv.SmartImageFactory;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.obb.config.ObbDetModelConfig;
import cn.smartjavaai.obb.criteria.ObbDetCriteriaFactory;
import cn.smartjavaai.obb.entity.ObbResult;
import cn.smartjavaai.obb.exception.ObbDetException;
import cn.smartjavaai.obb.model.ObbDetModel;
import cn.smartjavaai.obb.model.ObbDetModelFactory;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import cn.smartjavaai.vision.utils.DetectorUtils;
import cn.smartjavaai.vision.utils.ObbResultFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonObbDetModel
implements ObbDetModel {
    private static final Logger log = LoggerFactory.getLogger(CommonObbDetModel.class);
    private ObbDetModelConfig config;
    private ZooModel<Image, ObbResult> model;
    private GenericObjectPool<Predictor<Image, ObbResult>> predictorPool;
    private boolean fromFactory = false;

    @Override
    public void loadModel(ObbDetModelConfig config) {
        if (Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b\u679a\u4e3e");
        }
        Criteria<Image, ObbResult> criteria = ObbDetCriteriaFactory.createCriteria(config);
        this.config = config;
        try {
            this.model = criteria.loadModel();
            this.predictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.model));
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.predictorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u5f53\u524d\u8bbe\u5907: " + this.model.getNDManager().getDevice());
            log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new DetectionException("\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    @Override
    public R<DetectionResponse> detect(Image image) {
        ObbResult obbResult = this.detectCore(image);
        DetectionResponse detectionResponse = DetectorUtils.obbToToDetectionResponse(obbResult);
        return R.ok((Object)detectionResponse);
    }

    @Override
    public ObbResult detectCore(Image image) {
        Predictor predictor = null;
        try {
            predictor = (Predictor)this.predictorPool.borrowObject();
            ObbResult obbResult = (ObbResult)predictor.predict((Object)image);
            if (Objects.nonNull(obbResult) && CollectionUtils.isNotEmpty(obbResult.getRotatedBoxeList())) {
                ObbResultFilter obbResultFilter = new ObbResultFilter(this.config.getAllowedClasses(), this.config.getTopK());
                obbResult = obbResultFilter.filter(obbResult);
            }
            ObbResult obbResult2 = obbResult;
            return obbResult2;
        }
        catch (Exception e) {
            throw new DetectionException("\u65cb\u8f6c\u6846\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.predictorPool.returnObject((Object)predictor);
                    log.debug("\u91ca\u653e\u8d44\u6e90");
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    try {
                        predictor.close();
                    }
                    catch (Exception ex) {
                        log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public R<DetectionResponse> detectAndDraw(Image image) {
        ObbResult obbResult = this.detectCore(image);
        if (Objects.isNull(obbResult) || CollectionUtils.isEmpty(obbResult.getRotatedBoxeList())) {
            return R.fail((R.Status)R.Status.NO_OBJECT_DETECTED);
        }
        DetectorUtils.drawRectWithText(image, obbResult.getRotatedBoxeList());
        DetectionResponse detectionResponse = DetectorUtils.obbToToDetectionResponse(obbResult);
        detectionResponse.setDrawnImage(image);
        return R.ok((Object)detectionResponse);
    }

    @Override
    public R<DetectionResponse> detectAndDraw(String imagePath, String outputPath) {
        R r;
        ObbResult obbResult;
        Image img;
        block5: {
            img = null;
            img = SmartImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            obbResult = this.detectCore(img);
            if (!Objects.isNull(obbResult) && !CollectionUtils.isEmpty(obbResult.getRotatedBoxeList())) break block5;
            R r2 = R.fail((R.Status)R.Status.NO_OBJECT_DETECTED);
            ImageUtils.releaseOpenCVMat((Image)img);
            return r2;
        }
        try {
            DetectorUtils.drawRectWithText(img, obbResult.getRotatedBoxeList());
            img.save(Files.newOutputStream(Paths.get(outputPath, new String[0]), new OpenOption[0]), "png");
            DetectionResponse detectionResponse = DetectorUtils.obbToToDetectionResponse(obbResult);
            r = R.ok((Object)detectionResponse);
        }
        catch (IOException e) {
            try {
                throw new ObbDetException(e);
            }
            catch (Throwable throwable) {
                ImageUtils.releaseOpenCVMat(img);
                throw throwable;
            }
        }
        ImageUtils.releaseOpenCVMat((Image)img);
        return r;
    }

    @Override
    public void close() throws Exception {
        if (this.fromFactory) {
            ObbDetModelFactory.removeFromCache(this.config.getModelEnum());
        }
        try {
            if (this.predictorPool != null) {
                this.predictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.model != null) {
                this.model.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void setFromFactory(boolean fromFactory) {
        this.fromFactory = fromFactory;
    }

    public boolean isFromFactory() {
        return this.fromFactory;
    }
}

