/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.obb.entity;

import cn.smartjavaai.common.entity.Point;
import java.util.ArrayList;
import java.util.List;

public class YoloRotatedBox {
    public float cx;
    public float cy;
    public float w;
    public float h;
    public float angle;
    public float score;
    public String className;

    public YoloRotatedBox(float cx, float cy, float w, float h, float angle, String className, float score) {
        this.cx = cx;
        this.cy = cy;
        this.w = w;
        this.h = h;
        this.angle = angle;
        this.className = className;
        this.score = score;
    }

    public static double probiou(YoloRotatedBox b1, YoloRotatedBox b2, double eps) {
        double[] c1 = YoloRotatedBox.covarianceMatrix(b1.w, b1.h, b1.angle);
        double[] c2 = YoloRotatedBox.covarianceMatrix(b2.w, b2.h, b2.angle);
        double a1 = c1[0];
        double b1v = c1[1];
        double c1v = c1[2];
        double a2 = c2[0];
        double b2v = c2[1];
        double c2v = c2[2];
        double x1 = b1.cx;
        double y1 = b1.cy;
        double x2 = b2.cx;
        double y2 = b2.cy;
        double t1 = ((a1 + a2) * Math.pow(y1 - y2, 2.0) + (b1v + b2v) * Math.pow(x1 - x2, 2.0)) / ((a1 + a2) * (b1v + b2v) - Math.pow(c1v + c2v, 2.0) + eps);
        double t2 = (c1v + c2v) * (x2 - x1) * (y1 - y2) / ((a1 + a2) * (b1v + b2v) - Math.pow(c1v + c2v, 2.0) + eps);
        double t3 = Math.log(((a1 + a2) * (b1v + b2v) - Math.pow(c1v + c2v, 2.0)) / (4.0 * Math.sqrt(a1 * b1v - Math.pow(c1v, 2.0)) * Math.sqrt(a2 * b2v - Math.pow(c2v, 2.0)) + eps) + eps);
        double bd = 0.25 * t1 + 0.5 * t2 + 0.5 * t3;
        bd = Math.max(Math.min(bd, 100.0), eps);
        double hd = Math.sqrt(1.0 - Math.exp(-bd) + eps);
        return 1.0 - hd;
    }

    private static double[] covarianceMatrix(double w, double h, double r) {
        double a = Math.pow(w, 2.0) / 12.0;
        double b = Math.pow(h, 2.0) / 12.0;
        double cos = Math.cos(r);
        double sin = Math.sin(r);
        double aVal = a * cos * cos + b * sin * sin;
        double bVal = a * sin * sin + b * cos * cos;
        double cVal = (a - b) * sin * cos;
        return new double[]{aVal, bVal, cVal};
    }

    public List<Point> toPoints() {
        double cos = Math.cos(this.angle);
        double sin = Math.sin(this.angle);
        double vec1x = (double)this.w / 2.0 * cos;
        double vec1y = (double)this.w / 2.0 * sin;
        double vec2x = (double)(-this.h) / 2.0 * sin;
        double vec2y = (double)this.h / 2.0 * cos;
        ArrayList<Point> points = new ArrayList<Point>(4);
        points.add(new Point((double)((int)Math.round((double)this.cx + vec1x + vec2x)), (double)((int)Math.round((double)this.cy + vec1y + vec2y))));
        points.add(new Point((double)((int)Math.round((double)this.cx + vec1x - vec2x)), (double)((int)Math.round((double)this.cy + vec1y - vec2y))));
        points.add(new Point((double)((int)Math.round((double)this.cx - vec1x - vec2x)), (double)((int)Math.round((double)this.cy - vec1y - vec2y))));
        points.add(new Point((double)((int)Math.round((double)this.cx - vec1x + vec2x)), (double)((int)Math.round((double)this.cy - vec1y + vec2y))));
        return points;
    }
}

