/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.obb.criteria;

import ai.djl.Device;
import ai.djl.modality.cv.Image;
import ai.djl.repository.zoo.Criteria;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.Translator;
import ai.djl.util.Progress;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.obb.config.ObbDetModelConfig;
import cn.smartjavaai.obb.entity.ObbResult;
import cn.smartjavaai.obb.enums.ObbDetModelEnum;
import cn.smartjavaai.obb.exception.ObbDetException;
import cn.smartjavaai.obb.translator.YoloV11OddTranslator;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ObbDetCriteriaFactory {
    public static Criteria<Image, ObbResult> createCriteria(ObbDetModelConfig config) {
        Device device = null;
        if (!Objects.isNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
        }
        Translator<Image, ObbResult> translator = ObbDetCriteriaFactory.getTranslator(config);
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new ObbDetException("\u8bf7\u6307\u5b9a\u6a21\u578b\u8def\u5f84");
        }
        Criteria criteria = Criteria.builder().setTypes(Image.class, ObbResult.class).optModelPath(Paths.get(config.getModelPath(), new String[0])).optTranslator(translator).optDevice(device).optProgress((Progress)new ProgressBar()).optEngine(config.getModelEnum().getEngine()).build();
        return criteria;
    }

    public static Translator<Image, ObbResult> getTranslator(ObbDetModelConfig config) {
        YoloV11OddTranslator translator = null;
        if (config.getModelEnum() == ObbDetModelEnum.YOLOV11) {
            translator = YoloV11OddTranslator.builder().setImageSize(config.getModelEnum().getInputWidth(), config.getModelEnum().getInputHeight()).optThreshold(config.getThreshold() > 0.0f ? config.getThreshold() : 0.25f).optNmsThreshold(0.45f).optSynsetArtifactName("synset.txt").build();
        }
        return translator;
    }
}

