/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.instanceseg.criteria;

import ai.djl.Device;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.translator.InstanceSegmentationTranslatorFactory;
import ai.djl.repository.zoo.Criteria;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Progress;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.instanceseg.config.InstanceSegModelConfig;
import cn.smartjavaai.instanceseg.enums.InstanceSegModelEnum;
import cn.smartjavaai.instanceseg.translator.YoloSegmentationTranslatorFactory2;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class InstanceSegCriteriaFactory {
    public static Criteria<Image, DetectedObjects> createCriteria(InstanceSegModelConfig config) {
        Device device = null;
        if (!Objects.isNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
        }
        Criteria criteria = null;
        criteria = config.getModelEnum() == InstanceSegModelEnum.SEG_MASK_RCNN ? Criteria.builder().setTypes(Image.class, DetectedObjects.class).optModelUrls(StringUtils.isNotBlank((CharSequence)config.getModelPath()) ? null : config.getModelEnum().getModelUri()).optModelPath(StringUtils.isNotBlank((CharSequence)config.getModelPath()) ? Paths.get(config.getModelPath(), new String[0]) : null).optDevice(device).optEngine(config.getModelEnum().getEngine()).optArgument("normalize", (Object)"true").optArgument("synsetFileName", (Object)"classes.txt").optTranslatorFactory((TranslatorFactory)new InstanceSegmentationTranslatorFactory()).optProgress((Progress)new ProgressBar()).build() : Criteria.builder().setTypes(Image.class, DetectedObjects.class).optModelUrls(StringUtils.isNotBlank((CharSequence)config.getModelPath()) ? null : config.getModelEnum().getModelUri()).optModelPath(StringUtils.isNotBlank((CharSequence)config.getModelPath()) ? Paths.get(config.getModelPath(), new String[0]) : null).optDevice(device).optArgument("width", (Object)config.getModelEnum().getInputWidth()).optArgument("height", (Object)config.getModelEnum().getInputHeight()).optArgument("resize", (Object)"true").optArgument("threshold", (Object)Float.valueOf(config.getThreshold())).optEngine(config.getModelEnum().getEngine()).optTranslatorFactory((TranslatorFactory)new YoloSegmentationTranslatorFactory2()).optProgress((Progress)new ProgressBar()).build();
        return criteria;
    }
}

