/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.cls.model;

import cn.smartjavaai.cls.config.ClsModelConfig;
import cn.smartjavaai.cls.enums.ClsModelEnum;
import cn.smartjavaai.cls.model.ClsModel;
import cn.smartjavaai.cls.model.CommonClsModel;
import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClsModelFactory {
    private static final Logger log = LoggerFactory.getLogger(ClsModelFactory.class);
    private static volatile ClsModelFactory instance;
    private static final ConcurrentHashMap<ClsModelEnum, ClsModel> modelMap;
    private static final Map<ClsModelEnum, Class<? extends ClsModel>> registry;

    private ClsModelFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClsModelFactory getInstance() {
        if (instance != null) return instance;
        Class<ClsModelFactory> clazz = ClsModelFactory.class;
        synchronized (ClsModelFactory.class) {
            if (instance != null) return instance;
            instance = new ClsModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ClsModel getModel(ClsModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceDetModel(config));
    }

    private ClsModel createFaceDetModel(ClsModelConfig config) {
        Class<? extends ClsModel> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new DetectionException("Unsupported model");
        }
        ClsModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DetectionException(e);
        }
        model.loadModel(config);
        model.setFromFactory(true);
        return model;
    }

    private static void registerAlgorithm(ClsModelEnum modelEnum, Class<? extends ClsModel> clazz) {
        registry.put(modelEnum, clazz);
    }

    public void closeAll() {
        modelMap.values().forEach(model -> {
            try {
                model.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        modelMap.clear();
    }

    public static void removeFromCache(ClsModelEnum modelEnum) {
        modelMap.remove((Object)modelEnum);
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<ClsModelEnum, Class<? extends ClsModel>>();
        ClsModelFactory.registerAlgorithm(ClsModelEnum.YOLOV8, CommonClsModel.class);
        ClsModelFactory.registerAlgorithm(ClsModelEnum.YOLOV11, CommonClsModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

