/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.clip.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslatorContext;

public class TextTranslator
implements NoBatchifyTranslator<String, float[]> {
    HuggingFaceTokenizer tokenizer;

    public TextTranslator(HuggingFaceTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public float[] processOutput(TranslatorContext ctx, NDList list) {
        return list.singletonOrThrow().toFloatArray();
    }

    public NDList processInput(TranslatorContext ctx, String input) {
        Encoding encoding = this.tokenizer.encode(input);
        NDArray attention = ctx.getNDManager().create(encoding.getAttentionMask());
        NDArray inputIds = ctx.getNDManager().create(encoding.getIds());
        NDArray placeholder = ctx.getNDManager().create("");
        placeholder.setName("module_method:get_text_features");
        return new NDList(new NDArray[]{inputIds.expandDims(0), attention.expandDims(0), placeholder});
    }
}

