/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.clip.translator;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslatorContext;

public class ImageTranslator
implements NoBatchifyTranslator<Image, float[]> {
    public float[] processOutput(TranslatorContext ctx, NDList list) {
        NDArray array = list.singletonOrThrow();
        return array.toFloatArray();
    }

    public NDList processInput(TranslatorContext ctx, Image input) {
        NDArray array = input.toNDArray(ctx.getNDManager(), Image.Flag.COLOR);
        float percent = 224.0f / (float)Math.min(input.getWidth(), input.getHeight());
        int resizedWidth = Math.round((float)input.getWidth() * percent);
        int resizedHeight = Math.round((float)input.getHeight() * percent);
        array = NDImageUtils.resize((NDArray)array, (int)resizedWidth, (int)resizedHeight, (Image.Interpolation)Image.Interpolation.BICUBIC);
        array = NDImageUtils.centerCrop((NDArray)array, (int)224, (int)224);
        array = NDImageUtils.toTensor((NDArray)array);
        NDArray placeholder = ctx.getNDManager().create("");
        placeholder.setName("module_method:get_image_features");
        return new NDList(new NDArray[]{array.expandDims(0), placeholder});
    }
}

