/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.clip.translator;

import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.modality.cv.Image;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.Pair;
import cn.smartjavaai.clip.translator.ImageTranslator;
import cn.smartjavaai.clip.translator.TextTranslator;

public class ImageTextTranslator
implements NoBatchifyTranslator<Pair<Image, String>, float[]> {
    private ImageTranslator imgTranslator = new ImageTranslator();
    private TextTranslator txtTranslator;
    HuggingFaceTokenizer tokenizer;

    public ImageTextTranslator(HuggingFaceTokenizer tokenizer) {
        this.txtTranslator = new TextTranslator(tokenizer);
    }

    public float[] processOutput(TranslatorContext ctx, NDList list) throws Exception {
        NDArray logitsPerImage = (NDArray)list.get(0);
        return logitsPerImage.toFloatArray();
    }

    public NDList processInput(TranslatorContext ctx, Pair<Image, String> input) throws Exception {
        NDList imageInput = this.imgTranslator.processInput(ctx, (Image)input.getKey());
        NDList textInput = this.txtTranslator.processInput(ctx, (String)input.getValue());
        return new NDList(new NDArray[]{(NDArray)textInput.get(0), (NDArray)imageInput.get(0), (NDArray)textInput.get(1)});
    }
}

