/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.clip.model;

import cn.smartjavaai.clip.config.ClipModelConfig;
import cn.smartjavaai.clip.enums.ClipModelEnum;
import cn.smartjavaai.clip.model.ClipModel;
import cn.smartjavaai.clip.model.OpenAIClipModel;
import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClipModelFactory {
    private static final Logger log = LoggerFactory.getLogger(ClipModelFactory.class);
    private static volatile ClipModelFactory instance;
    private static final ConcurrentHashMap<ClipModelEnum, ClipModel> modelMap;
    private static final Map<ClipModelEnum, Class<? extends ClipModel>> registry;

    private ClipModelFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClipModelFactory getInstance() {
        if (instance != null) return instance;
        Class<ClipModelFactory> clazz = ClipModelFactory.class;
        synchronized (ClipModelFactory.class) {
            if (instance != null) return instance;
            instance = new ClipModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ClipModel getModel(ClipModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceDetModel(config));
    }

    private ClipModel createFaceDetModel(ClipModelConfig config) {
        Class<? extends ClipModel> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new DetectionException("Unsupported model");
        }
        ClipModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DetectionException(e);
        }
        model.loadModel(config);
        model.setFromFactory(true);
        return model;
    }

    private static void registerAlgorithm(ClipModelEnum modelEnum, Class<? extends ClipModel> clazz) {
        registry.put(modelEnum, clazz);
    }

    public void closeAll() {
        modelMap.values().forEach(model -> {
            try {
                model.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        modelMap.clear();
    }

    public static void removeFromCache(ClipModelEnum modelEnum) {
        modelMap.remove((Object)modelEnum);
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<ClipModelEnum, Class<? extends ClipModel>>();
        ClipModelFactory.registerAlgorithm(ClipModelEnum.OPENAI, OpenAIClipModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

