/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.action.model;

import cn.smartjavaai.action.config.ActionRecModelConfig;
import cn.smartjavaai.action.enums.ActionRecModelEnum;
import cn.smartjavaai.action.model.ActionRecModel;
import cn.smartjavaai.action.model.CommonActionRecModel;
import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionRecModelFactory {
    private static final Logger log = LoggerFactory.getLogger(ActionRecModelFactory.class);
    private static volatile ActionRecModelFactory instance;
    private static final ConcurrentHashMap<ActionRecModelEnum, ActionRecModel> modelMap;
    private static final Map<ActionRecModelEnum, Class<? extends ActionRecModel>> registry;

    private ActionRecModelFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActionRecModelFactory getInstance() {
        if (instance != null) return instance;
        Class<ActionRecModelFactory> clazz = ActionRecModelFactory.class;
        synchronized (ActionRecModelFactory.class) {
            if (instance != null) return instance;
            instance = new ActionRecModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ActionRecModel getModel(ActionRecModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceDetModel(config));
    }

    private ActionRecModel createFaceDetModel(ActionRecModelConfig config) {
        Class<? extends ActionRecModel> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new DetectionException("Unsupported model");
        }
        ActionRecModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DetectionException(e);
        }
        model.loadModel(config);
        model.setFromFactory(true);
        return model;
    }

    private static void registerAlgorithm(ActionRecModelEnum modelEnum, Class<? extends ActionRecModel> clazz) {
        registry.put(modelEnum, clazz);
    }

    public void closeAll() {
        modelMap.values().forEach(model -> {
            try {
                model.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        modelMap.clear();
    }

    public static void removeFromCache(ActionRecModelEnum modelEnum) {
        modelMap.remove((Object)modelEnum);
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<ActionRecModelEnum, Class<? extends ActionRecModel>>();
        ActionRecModelFactory.registerAlgorithm(ActionRecModelEnum.INCEPTIONV1_KINETICS400_ONNX, CommonActionRecModel.class);
        ActionRecModelFactory.registerAlgorithm(ActionRecModelEnum.INCEPTIONV3_KINETICS400_ONNX, CommonActionRecModel.class);
        ActionRecModelFactory.registerAlgorithm(ActionRecModelEnum.RESNET_V1B_KINETICS400_ONNX, CommonActionRecModel.class);
        ActionRecModelFactory.registerAlgorithm(ActionRecModelEnum.VIT_BASE_PATCH16_224_DJL, CommonActionRecModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

