/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.action.criteria;

import ai.djl.Device;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.Image;
import ai.djl.repository.zoo.Criteria;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.Translator;
import ai.djl.util.Progress;
import cn.smartjavaai.action.config.ActionRecModelConfig;
import cn.smartjavaai.action.enums.ActionRecModelEnum;
import cn.smartjavaai.action.exception.ActionException;
import cn.smartjavaai.action.model.CommonActionTranslator;
import cn.smartjavaai.common.enums.DeviceEnum;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ActionRecCriteriaFactory {
    public static Criteria<Image, Classifications> createCriteria(ActionRecModelConfig config) {
        Device device = null;
        if (!Objects.isNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
        }
        Translator<Image, Classifications> translator = ActionRecCriteriaFactory.getTranslator(config);
        if (StringUtils.isBlank((CharSequence)config.getModelEnum().getModelUrl()) && StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new ActionException("\u8bf7\u6307\u5b9a\u6a21\u578b\u8def\u5f84");
        }
        Criteria criteria = Criteria.builder().setTypes(Image.class, Classifications.class).optModelUrls(StringUtils.isNotBlank((CharSequence)config.getModelPath()) ? null : config.getModelEnum().getModelUrl()).optModelPath(StringUtils.isNotBlank((CharSequence)config.getModelPath()) ? Paths.get(config.getModelPath(), new String[0]) : null).optTranslator(translator).optDevice(device).optProgress((Progress)new ProgressBar()).optEngine(config.getModelEnum().getEngine()).build();
        return criteria;
    }

    public static Translator<Image, Classifications> getTranslator(ActionRecModelConfig config) {
        CommonActionTranslator translator = null;
        if (config.getModelEnum() == ActionRecModelEnum.INCEPTIONV1_KINETICS400_ONNX || config.getModelEnum() == ActionRecModelEnum.INCEPTIONV3_KINETICS400_ONNX || config.getModelEnum() == ActionRecModelEnum.INCEPTIONV3_KINETICS400_ONNX) {
            translator = new CommonActionTranslator(config.getModelEnum().getInputWidth(), config.getModelEnum().getInputHeight());
        }
        return translator;
    }
}

