/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.vision.utils;

import ai.djl.util.JsonUtils;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;

public class TensorflowSynsetUtils {
    public static Map<Integer, String> loadSynset(URL synsetUrl) throws IOException {
        return TensorflowSynsetUtils.loadSynset(synsetUrl.openStream());
    }

    public static Map<Integer, String> loadSynset(Path synsetPath) throws IOException {
        return TensorflowSynsetUtils.loadSynset(Files.newInputStream(synsetPath, new OpenOption[0]));
    }

    public static Map<Integer, String> loadSynset(InputStream inputStream) throws IOException {
        ConcurrentHashMap<Integer, String> map = new ConcurrentHashMap<Integer, String>();
        int maxId = 0;
        try (BufferedInputStream is = new BufferedInputStream(inputStream);
             Scanner scanner = new Scanner((InputStream)is, StandardCharsets.UTF_8.name());){
            scanner.useDelimiter("item ");
            while (scanner.hasNext()) {
                String content = scanner.next();
                content = content.replaceAll("(\"|\\d)\\n\\s", "$1,");
                Item item = (Item)JsonUtils.GSON.fromJson(content, Item.class);
                map.put(item.id, item.displayName);
                if (item.id <= maxId) continue;
                maxId = item.id;
            }
        }
        return map;
    }

    private static final class Item {
        int id;
        @SerializedName(value="display_name")
        String displayName;

        private Item() {
        }
    }
}

