/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.vision.utils;

import cn.smartjavaai.obb.entity.ObbResult;
import cn.smartjavaai.obb.entity.YoloRotatedBox;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ObbResultFilter {
    private List<String> allowedClasses;
    private int topK;

    public ObbResultFilter(List<String> allowedClasses, int topK) {
        this.allowedClasses = allowedClasses;
        this.topK = topK;
    }

    public ObbResult filter(ObbResult result) {
        if (result == null || result.getRotatedBoxeList() == null) {
            return new ObbResult(Collections.emptyList());
        }
        List<YoloRotatedBox> filtered = result.getRotatedBoxeList();
        if (CollectionUtils.isNotEmpty(this.allowedClasses)) {
            filtered = result.getRotatedBoxeList().stream().filter((? super T box) -> this.allowedClasses.contains(box.className)).collect(Collectors.toList());
        }
        if (this.topK > 0 && filtered.size() > this.topK) {
            filtered = filtered.subList(0, this.topK);
        }
        return new ObbResult(filtered);
    }
}

