/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.vision.utils;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Mask;
import ai.djl.modality.cv.output.Rectangle;
import cn.smartjavaai.common.entity.DetectionInfo;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.InstanceSegInfo;
import cn.smartjavaai.common.entity.ObbDetInfo;
import cn.smartjavaai.common.entity.ObjectDetInfo;
import cn.smartjavaai.common.entity.Point;
import cn.smartjavaai.common.entity.RotatedBox;
import cn.smartjavaai.obb.entity.ObbResult;
import cn.smartjavaai.obb.entity.YoloRotatedBox;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;

public class DetectorUtils {
    public static DetectionResponse convertToDetectionResponse(DetectedObjects detection, Image img) {
        if (Objects.isNull(detection) || Objects.isNull(detection.getProbabilities()) || detection.getProbabilities().isEmpty() || Objects.isNull(detection.items()) || detection.items().isEmpty()) {
            return null;
        }
        DetectionResponse detectionResponse = new DetectionResponse();
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        List detectedObjectList = detection.items();
        Iterator iterator = detectedObjectList.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            DetectedObjects.DetectedObject result = (DetectedObjects.DetectedObject)iterator.next();
            String className = result.getClassName();
            BoundingBox box = result.getBoundingBox();
            int x = (int)(box.getBounds().getX() * (double)img.getWidth());
            int y = (int)(box.getBounds().getY() * (double)img.getHeight());
            int width = (int)(box.getBounds().getWidth() * (double)img.getWidth());
            int height = (int)(box.getBounds().getHeight() * (double)img.getHeight());
            DetectionRectangle rectangle = new DetectionRectangle(x, y, width, height);
            DetectionInfo detectionInfo = new DetectionInfo(rectangle, ((Double)detection.getProbabilities().get(index)).floatValue());
            if (box instanceof Mask) {
                Mask mask = (Mask)box;
                InstanceSegInfo instanceSegInfo = new InstanceSegInfo(className, mask.getProbDist());
                detectionInfo.setInstanceSegInfo(instanceSegInfo);
            } else if (box instanceof Rectangle) {
                ObjectDetInfo objectDetInfo = new ObjectDetInfo(className);
                detectionInfo.setObjectDetInfo(objectDetInfo);
            }
            detectionInfoList.add(detectionInfo);
            ++index;
        }
        detectionResponse.setDetectionInfoList(detectionInfoList);
        return detectionResponse;
    }

    public static DetectionResponse obbToToDetectionResponse(ObbResult obbResult) {
        if (Objects.isNull(obbResult) || CollectionUtils.isEmpty(obbResult.getRotatedBoxeList())) {
            return null;
        }
        DetectionResponse detectionResponse = new DetectionResponse();
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        for (YoloRotatedBox box : obbResult.getRotatedBoxeList()) {
            List<Point> points = box.toPoints();
            RotatedBox rotatedBox = new RotatedBox(points.get(0), points.get(1), points.get(2), points.get(3));
            ObbDetInfo obbDetInfo = new ObbDetInfo(box.className, rotatedBox);
            DetectionInfo detectionInfo = new DetectionInfo();
            detectionInfo.setScore(box.score);
            detectionInfo.setObbDetInfo(obbDetInfo);
            detectionInfoList.add(detectionInfo);
        }
        detectionResponse.setDetectionInfoList(detectionInfoList);
        return detectionResponse;
    }

    public static void drawRectWithText(Mat srcMat, List<YoloRotatedBox> rotatedBoxeList) {
        for (YoloRotatedBox box : rotatedBoxeList) {
            List<Point> points = box.toPoints();
            Imgproc.line((Mat)srcMat, (org.opencv.core.Point)points.get(0).toCvPoint(), (org.opencv.core.Point)points.get(1).toCvPoint(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
            Imgproc.line((Mat)srcMat, (org.opencv.core.Point)points.get(1).toCvPoint(), (org.opencv.core.Point)points.get(2).toCvPoint(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
            Imgproc.line((Mat)srcMat, (org.opencv.core.Point)points.get(2).toCvPoint(), (org.opencv.core.Point)points.get(3).toCvPoint(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
            Imgproc.line((Mat)srcMat, (org.opencv.core.Point)points.get(3).toCvPoint(), (org.opencv.core.Point)points.get(0).toCvPoint(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
            Imgproc.putText((Mat)srcMat, (String)box.className, (org.opencv.core.Point)points.get(0).toCvPoint(), (int)0, (double)1.0, (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
        }
    }

    public static void drawRectWithText(BufferedImage image, List<YoloRotatedBox> rotatedBoxeList) {
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fm = g2d.getFontMetrics();
        for (YoloRotatedBox box : rotatedBoxeList) {
            g2d.setColor(Color.GREEN);
            g2d.setStroke(new BasicStroke(1.5f));
            g2d.setFont(new Font("SansSerif", 0, 16));
            List<Point> points = box.toPoints();
            g2d.drawLine((int)points.get(0).getX(), (int)points.get(0).getY(), (int)points.get(1).getX(), (int)points.get(1).getY());
            g2d.drawLine((int)points.get(1).getX(), (int)points.get(1).getY(), (int)points.get(2).getX(), (int)points.get(2).getY());
            g2d.drawLine((int)points.get(2).getX(), (int)points.get(2).getY(), (int)points.get(3).getX(), (int)points.get(3).getY());
            g2d.drawLine((int)points.get(3).getX(), (int)points.get(3).getY(), (int)points.get(0).getX(), (int)points.get(0).getY());
            int percent = Math.round(box.score * 100.0f);
            String className = box.className + " " + percent + "%";
            int textWidth = fm.stringWidth(box.className + " " + box.score);
            int textHeight = fm.getHeight();
            int textX = (int)points.get(0).getX();
            int textY = (int)points.get(0).getY() - 5;
            g2d.setColor(new Color(0, 0, 0, 128));
            g2d.fillRect(textX, textY - textHeight, textWidth, textHeight);
            g2d.setColor(Color.WHITE);
            g2d.drawString(className, (int)points.get(0).getX(), (int)points.get(0).getY() - 5);
        }
        g2d.dispose();
    }

    public static void drawRectWithText(Image image, List<YoloRotatedBox> rotatedBoxeList) {
        if (image.getWrappedImage() instanceof BufferedImage) {
            DetectorUtils.drawRectWithText((BufferedImage)image.getWrappedImage(), rotatedBoxeList);
        } else {
            DetectorUtils.drawRectWithText((Mat)image.getWrappedImage(), rotatedBoxeList);
        }
    }
}

