/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.semseg.criteria;

import ai.djl.Device;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.CategoryMask;
import ai.djl.modality.cv.translator.SemanticSegmentationTranslatorFactory;
import ai.djl.repository.zoo.Criteria;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Progress;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.semseg.config.SemSegModelConfig;
import cn.smartjavaai.semseg.enums.SemSegModelEnum;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class SemSegCriteriaFactory {
    public static Criteria<Image, CategoryMask> createCriteria(SemSegModelConfig config) {
        Device device = null;
        if (!Objects.isNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
        }
        Criteria criteria = null;
        ConcurrentHashMap params = new ConcurrentHashMap();
        params.putAll(config.getCustomParams());
        if (config.getModelEnum() == SemSegModelEnum.DEEPLABV3) {
            criteria = Criteria.builder().setTypes(Image.class, CategoryMask.class).optModelUrls(StringUtils.isNotBlank((CharSequence)config.getModelPath()) ? null : config.getModelEnum().getModelUri()).optModelPath(StringUtils.isNotBlank((CharSequence)config.getModelPath()) ? Paths.get(config.getModelPath(), new String[0]) : null).optTranslatorFactory((TranslatorFactory)new SemanticSegmentationTranslatorFactory()).optEngine("PyTorch").optDevice(device).optProgress((Progress)new ProgressBar()).build();
        }
        return criteria;
    }
}

