/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.pose.enums;

public enum PoseModelEnum {
    YOLO11N_POSE_PT("djl://ai.djl.pytorch/yolo11n-pose"),
    YOLOV8N_POSE_PT("djl://ai.djl.pytorch/yolov8n-pose"),
    YOLO11N_POSE_ONNX("djl://ai.djl.onnxruntime/yolo11n-pose"),
    YOLOV8N_POSE_ONNX("djl://ai.djl.onnxruntime/yolov8n-pose");

    private final String modelUri;

    public static PoseModelEnum fromName(String name) {
        String formatted = name.trim().toUpperCase().replaceAll("[-_]", "");
        for (PoseModelEnum model : PoseModelEnum.values()) {
            if (!model.name().replaceAll("_", "").equals(formatted)) continue;
            return model;
        }
        throw new IllegalArgumentException("\u672a\u77e5\u6a21\u578b\u540d\u79f0: " + name);
    }

    private PoseModelEnum(String modelUri) {
        this.modelUri = modelUri;
    }

    public String getModelUri() {
        return this.modelUri;
    }
}

