/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.objectdetection.translator;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.DataType;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class TensorflowTranslator
implements NoBatchifyTranslator<Image, DetectedObjects> {
    private Map<Integer, String> classes;
    private int maxBoxes;
    private float threshold;

    public TensorflowTranslator(Map<String, ?> arguments) {
        this.maxBoxes = arguments.containsKey("maxBoxes") ? Integer.parseInt(arguments.get("maxBoxes").toString()) : 10;
        this.threshold = arguments.containsKey("threshold") ? Float.parseFloat(arguments.get("threshold").toString()) : 0.7f;
        this.classes = (Map)arguments.get("classes");
    }

    public NDList processInput(TranslatorContext ctx, Image input) {
        NDArray array = input.toNDArray(ctx.getNDManager(), Image.Flag.COLOR);
        array = NDImageUtils.resize((NDArray)array, (int)224);
        array = array.toType(DataType.UINT8, true);
        array = array.expandDims(0);
        return new NDList(new NDArray[]{array});
    }

    public void prepare(TranslatorContext ctx) throws IOException {
    }

    public DetectedObjects processOutput(TranslatorContext ctx, NDList list) {
        int[] classIds = null;
        float[] probabilities = null;
        NDArray boundingBoxes = null;
        for (NDArray array : list) {
            if ("detection_boxes".equals(array.getName())) {
                boundingBoxes = array.get(new long[]{0L});
                continue;
            }
            if ("detection_scores".equals(array.getName())) {
                probabilities = array.get(new long[]{0L}).toFloatArray();
                continue;
            }
            if (!"detection_classes".equals(array.getName())) continue;
            classIds = array.get(new long[]{0L}).toType(DataType.INT32, true).toIntArray();
        }
        Objects.requireNonNull(classIds);
        Objects.requireNonNull(probabilities);
        Objects.requireNonNull(boundingBoxes);
        ArrayList<String> retNames = new ArrayList<String>();
        ArrayList<Double> retProbs = new ArrayList<Double>();
        ArrayList<Rectangle> retBB = new ArrayList<Rectangle>();
        for (int i = 0; i < Math.min(classIds.length, this.maxBoxes); ++i) {
            int classId = classIds[i];
            double probability = probabilities[i];
            if (classId <= 0 || !(probability > (double)this.threshold)) continue;
            String className = this.classes.getOrDefault(classId, "#" + classId);
            float[] box = boundingBoxes.get(new long[]{i}).toFloatArray();
            float yMin = box[0];
            float xMin = box[1];
            float yMax = box[2];
            float xMax = box[3];
            Rectangle rect = new Rectangle((double)xMin, (double)yMin, (double)(xMax - xMin), (double)(yMax - yMin));
            retNames.add(className);
            retProbs.add(probability);
            retBB.add(rect);
        }
        return new DetectedObjects(retNames, retProbs, retBB);
    }
}

