/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.objectdetection.model.person;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.objectdetection.config.PersonDetModelConfig;
import cn.smartjavaai.objectdetection.enums.PersonDetectorModelEnum;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import cn.smartjavaai.objectdetection.model.person.CommonPersonDetModel;
import cn.smartjavaai.objectdetection.model.person.PersonDetModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonDetModelFactory {
    private static final Logger log = LoggerFactory.getLogger(PersonDetModelFactory.class);
    private static volatile PersonDetModelFactory instance;
    private static final ConcurrentHashMap<PersonDetectorModelEnum, PersonDetModel> modelMap;
    private static final Map<PersonDetectorModelEnum, Class<? extends PersonDetModel>> registry;

    private PersonDetModelFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PersonDetModelFactory getInstance() {
        if (instance != null) return instance;
        Class<PersonDetModelFactory> clazz = PersonDetModelFactory.class;
        synchronized (PersonDetModelFactory.class) {
            if (instance != null) return instance;
            instance = new PersonDetModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public PersonDetModel getModel(PersonDetModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceDetModel(config));
    }

    private PersonDetModel createFaceDetModel(PersonDetModelConfig config) {
        Class<? extends PersonDetModel> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new DetectionException("Unsupported model");
        }
        PersonDetModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DetectionException(e);
        }
        model.loadModel(config);
        return model;
    }

    private static void registerAlgorithm(PersonDetectorModelEnum modelEnum, Class<? extends PersonDetModel> clazz) {
        registry.put(modelEnum, clazz);
    }

    public static void removeFromCache(PersonDetectorModelEnum modelEnum) {
        modelMap.remove((Object)modelEnum);
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<PersonDetectorModelEnum, Class<? extends PersonDetModel>>();
        PersonDetModelFactory.registerAlgorithm(PersonDetectorModelEnum.YOLOV8_PERSON, CommonPersonDetModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

