/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.objectdetection.model.person;

import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import cn.smartjavaai.common.cv.SmartImageFactory;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.obb.exception.ObbDetException;
import cn.smartjavaai.objectdetection.config.PersonDetModelConfig;
import cn.smartjavaai.objectdetection.criteria.PersonDetCriteriaFactory;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import cn.smartjavaai.objectdetection.model.person.PersonDetModel;
import cn.smartjavaai.vision.utils.DetectedObjectsFilter;
import cn.smartjavaai.vision.utils.DetectorUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPersonDetModel
implements PersonDetModel {
    private static final Logger log = LoggerFactory.getLogger(CommonPersonDetModel.class);
    private PersonDetModelConfig config;
    private ZooModel<Image, DetectedObjects> model;
    private GenericObjectPool<Predictor<Image, DetectedObjects>> predictorPool;

    @Override
    public void loadModel(PersonDetModelConfig config) {
        if (Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b\u679a\u4e3e");
        }
        Criteria<Image, DetectedObjects> criteria = PersonDetCriteriaFactory.createCriteria(config);
        this.config = config;
        try {
            this.model = criteria.loadModel();
            this.predictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.model));
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.predictorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u5f53\u524d\u8bbe\u5907: " + this.model.getNDManager().getDevice());
            log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new DetectionException("\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    @Override
    public R<DetectionResponse> detect(Image image) {
        DetectedObjects detectedObjects = this.detectCore(image);
        DetectionResponse detectionResponse = DetectorUtils.convertToDetectionResponse(detectedObjects, image);
        return R.ok((Object)detectionResponse);
    }

    @Override
    public DetectedObjects detectCore(Image image) {
        Predictor predictor = null;
        try {
            predictor = (Predictor)this.predictorPool.borrowObject();
            DetectedObjects detectedObjects = (DetectedObjects)predictor.predict((Object)image);
            if (Objects.nonNull(detectedObjects) && detectedObjects.getNumberOfObjects() > 0) {
                DetectedObjectsFilter detectedObjectsFilter = new DetectedObjectsFilter(null, this.config.getTopK());
                detectedObjects = detectedObjectsFilter.filter(detectedObjects);
            }
            DetectedObjects detectedObjects2 = detectedObjects;
            return detectedObjects2;
        }
        catch (Exception e) {
            throw new DetectionException("\u884c\u4eba\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.predictorPool.returnObject((Object)predictor);
                    log.debug("\u91ca\u653e\u8d44\u6e90");
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    try {
                        predictor.close();
                    }
                    catch (Exception ex) {
                        log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public R<DetectionResponse> detectAndDraw(Image image) {
        DetectedObjects detectedObjects = this.detectCore(image);
        if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
            return R.fail((R.Status)R.Status.NO_OBJECT_DETECTED);
        }
        Image drawnImage = ImageUtils.copy((Image)image);
        drawnImage.drawBoundingBoxes(detectedObjects);
        DetectionResponse detectionResponse = DetectorUtils.convertToDetectionResponse(detectedObjects, drawnImage);
        detectionResponse.setDrawnImage(drawnImage);
        return R.ok((Object)detectionResponse);
    }

    @Override
    public R<DetectionResponse> detectAndDraw(String imagePath, String outputPath) {
        try {
            Image img = SmartImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            DetectedObjects detectedObjects = this.detectCore(img);
            if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
                return R.fail((R.Status)R.Status.NO_OBJECT_DETECTED);
            }
            img.drawBoundingBoxes(detectedObjects);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            img.save((OutputStream)new FileOutputStream(Paths.get(outputPath, new String[0]).toAbsolutePath().toString()), "png");
            DetectionResponse detectionResponse = DetectorUtils.convertToDetectionResponse(detectedObjects, img);
            return R.ok((Object)detectionResponse);
        }
        catch (IOException e) {
            throw new ObbDetException(e);
        }
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.predictorPool != null) {
                this.predictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.model != null) {
                this.model.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }
}

