/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.objectdetection.criteria;

import ai.djl.Device;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.repository.zoo.Criteria;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.Translator;
import ai.djl.util.Progress;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.obb.exception.ObbDetException;
import cn.smartjavaai.objectdetection.config.PersonDetModelConfig;
import cn.smartjavaai.objectdetection.enums.PersonDetectorModelEnum;
import cn.smartjavaai.objectdetection.translator.YoloV8PersonDetTranslator;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PersonDetCriteriaFactory {
    public static Criteria<Image, DetectedObjects> createCriteria(PersonDetModelConfig config) {
        Device device = null;
        if (!Objects.isNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
        }
        Translator<Image, DetectedObjects> translator = PersonDetCriteriaFactory.getTranslator(config);
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new ObbDetException("\u8bf7\u6307\u5b9a\u6a21\u578b\u8def\u5f84");
        }
        Criteria criteria = Criteria.builder().setTypes(Image.class, DetectedObjects.class).optModelPath(Paths.get(config.getModelPath(), new String[0])).optTranslator(translator).optDevice(device).optProgress((Progress)new ProgressBar()).optEngine(config.getModelEnum().getEngine()).build();
        return criteria;
    }

    public static Translator<Image, DetectedObjects> getTranslator(PersonDetModelConfig config) {
        YoloV8PersonDetTranslator translator = null;
        if (config.getModelEnum() == PersonDetectorModelEnum.YOLOV8_PERSON) {
            translator = YoloV8PersonDetTranslator.builder().setImageSize(config.getModelEnum().getInputSize(), config.getModelEnum().getInputSize()).optThreshold(config.getThreshold() > 0.0f ? config.getThreshold() : 0.5f).optNmsThreshold(0.45f).build();
        }
        return translator;
    }
}

