/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.instanceseg.model;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.instanceseg.config.InstanceSegModelConfig;
import cn.smartjavaai.instanceseg.enums.InstanceSegModelEnum;
import cn.smartjavaai.instanceseg.model.CommonInstanceSegModel;
import cn.smartjavaai.instanceseg.model.InstanceSegModel;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceSegModelFactory {
    private static final Logger log = LoggerFactory.getLogger(InstanceSegModelFactory.class);
    private static volatile InstanceSegModelFactory instance;
    private static final ConcurrentHashMap<InstanceSegModelEnum, InstanceSegModel> modelMap;
    private static final Map<InstanceSegModelEnum, Class<? extends InstanceSegModel>> registry;

    private InstanceSegModelFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InstanceSegModelFactory getInstance() {
        if (instance != null) return instance;
        Class<InstanceSegModelFactory> clazz = InstanceSegModelFactory.class;
        synchronized (InstanceSegModelFactory.class) {
            if (instance != null) return instance;
            instance = new InstanceSegModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public InstanceSegModel getModel(InstanceSegModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceDetModel(config));
    }

    private InstanceSegModel createFaceDetModel(InstanceSegModelConfig config) {
        Class<? extends InstanceSegModel> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new DetectionException("Unsupported model");
        }
        InstanceSegModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DetectionException(e);
        }
        model.loadModel(config);
        model.setFromFactory(true);
        return model;
    }

    private static void registerAlgorithm(InstanceSegModelEnum modelEnum, Class<? extends InstanceSegModel> clazz) {
        registry.put(modelEnum, clazz);
    }

    public static void removeFromCache(InstanceSegModelEnum modelEnum) {
        modelMap.remove((Object)modelEnum);
    }

    public void closeAll() {
        modelMap.values().forEach(model -> {
            try {
                model.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        modelMap.clear();
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<InstanceSegModelEnum, Class<? extends InstanceSegModel>>();
        InstanceSegModelFactory.registerAlgorithm(InstanceSegModelEnum.SEG_YOLOV8N_ONNX, CommonInstanceSegModel.class);
        InstanceSegModelFactory.registerAlgorithm(InstanceSegModelEnum.SEG_YOLOV8N_PYTORCH, CommonInstanceSegModel.class);
        InstanceSegModelFactory.registerAlgorithm(InstanceSegModelEnum.SEG_YOLO11N_PYTORCH, CommonInstanceSegModel.class);
        InstanceSegModelFactory.registerAlgorithm(InstanceSegModelEnum.SEG_YOLO11N_ONNX, CommonInstanceSegModel.class);
        InstanceSegModelFactory.registerAlgorithm(InstanceSegModelEnum.SEG_MASK_RCNN, CommonInstanceSegModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

