/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.instanceseg.enums;

public enum InstanceSegModelEnum {
    SEG_YOLO11N_PYTORCH("PyTorch", 640, 640, "djl://ai.djl.pytorch/yolo11n-seg"),
    SEG_YOLOV8N_PYTORCH("PyTorch", 640, 640, "djl://ai.djl.pytorch/yolov8n-seg"),
    SEG_YOLO11N_ONNX("OnnxRuntime", 640, 640, "djl://ai.djl.onnxruntime/yolo11n-seg"),
    SEG_YOLOV8N_ONNX("OnnxRuntime", 640, 640, "djl://ai.djl.onnxruntime/yolov8n-seg"),
    SEG_MASK_RCNN("MXNet", 0, 0, "djl://ai.djl.mxnet/mask_rcnn");

    private final int inputWidth;
    private final int inputHeight;
    private final String modelUri;
    private final String engine;

    public static InstanceSegModelEnum fromName(String name) {
        String formatted = name.trim().toUpperCase().replaceAll("[-_]", "");
        for (InstanceSegModelEnum model : InstanceSegModelEnum.values()) {
            if (!model.name().replaceAll("_", "").equals(formatted)) continue;
            return model;
        }
        throw new IllegalArgumentException("\u672a\u77e5\u6a21\u578b\u540d\u79f0: " + name);
    }

    private InstanceSegModelEnum(String engine, int inputWidth, int inputHeight, String modelUri) {
        this.inputWidth = inputWidth;
        this.inputHeight = inputHeight;
        this.modelUri = modelUri;
        this.engine = engine;
    }

    public String getModelUri() {
        return this.modelUri;
    }

    public String getEngine() {
        return this.engine;
    }

    public int getInputWidth() {
        return this.inputWidth;
    }

    public int getInputHeight() {
        return this.inputHeight;
    }
}

