/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.speech.asr.model;

import ai.djl.modality.audio.Audio;
import cn.smartjavaai.common.entity.Language;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.speech.asr.audio.SmartAudioFactory;
import cn.smartjavaai.speech.asr.config.AsrModelConfig;
import cn.smartjavaai.speech.asr.entity.AsrResult;
import cn.smartjavaai.speech.asr.entity.AsrSegment;
import cn.smartjavaai.speech.asr.entity.RecParams;
import cn.smartjavaai.speech.asr.entity.WhisperParams;
import cn.smartjavaai.speech.asr.exception.AsrException;
import cn.smartjavaai.speech.asr.factory.SpeechRecognizerFactory;
import cn.smartjavaai.speech.asr.model.SpeechRecognizer;
import cn.smartjavaai.speech.asr.pool.WhisperStatePool;
import io.github.givimad.whisperjni.WhisperContext;
import io.github.givimad.whisperjni.WhisperGrammar;
import io.github.givimad.whisperjni.WhisperJNI;
import io.github.givimad.whisperjni.WhisperState;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import javax.sound.sampled.AudioFormat;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhisperRecognizer
implements SpeechRecognizer {
    private static final Logger log = LoggerFactory.getLogger(WhisperRecognizer.class);
    private WhisperJNI whisper;
    private WhisperContext ctx;
    private WhisperStatePool statePool;
    private AsrModelConfig config;
    private boolean fromFactory = false;

    @Override
    public void loadModel(AsrModelConfig config) {
        this.config = config;
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new AsrException("modelPath is null");
        }
        Path testModelPath = Paths.get(config.getModelPath(), new String[0]);
        if (!testModelPath.toFile().exists()) {
            throw new AsrException("Missing model file: " + testModelPath.toAbsolutePath());
        }
        try {
            if (Objects.nonNull(config.getLibPath())) {
                System.setProperty("io.github.givimad.whisperjni.libdir", config.getLibPath().toAbsolutePath().toString());
            }
            WhisperJNI.loadLibrary();
            WhisperJNI.setLibraryLogger(null);
            this.whisper = new WhisperJNI();
            WhisperJNI.setLibraryLogger((WhisperJNI.LibraryLogger)new WhisperJNI.LibraryLogger(){

                public void log(String s) {
                    log.debug("WhisperJNI {}", (Object)s);
                }
            });
            this.ctx = this.whisper.initNoState(testModelPath);
            Boolean initOpenVINO = (Boolean)config.getCustomParam("initOpenVINO", Boolean.class);
            if (Objects.nonNull(initOpenVINO) && initOpenVINO.booleanValue()) {
                String device = Objects.isNull(config.getDevice()) ? DeviceEnum.CPU.name() : config.getDevice().name();
                this.whisper.initOpenVINO(this.ctx, device);
                log.debug("WhisperJNI initOpenVINO success");
            }
            this.statePool = new WhisperStatePool(this.whisper, this.ctx);
            log.debug("WhisperJNI init success");
        }
        catch (IOException e) {
            throw new AsrException(e);
        }
    }

    @Override
    public R<AsrResult> recognize(String audioPath, RecParams params) {
        Path audioFilePath = Paths.get(audioPath, new String[0]);
        if (!audioFilePath.toFile().exists()) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Audio audio = null;
        try {
            audio = SmartAudioFactory.getInstance().fromFile(audioFilePath, this.getDefaultAudioFormat());
        }
        catch (IOException e) {
            throw new AsrException("\u8bfb\u53d6\u97f3\u9891\u5f02\u5e38", e);
        }
        return this.recognize(audio, params);
    }

    @Override
    public R<AsrResult> recognize(byte[] audioData, RecParams params) {
        R<AsrResult> r;
        ByteArrayInputStream is = new ByteArrayInputStream(audioData);
        try {
            r = this.recognize(is, params);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AsrException(e);
            }
        }
        ((InputStream)is).close();
        return r;
    }

    @Override
    public R<AsrResult> recognize(InputStream audioStream, RecParams params) {
        Audio audio = null;
        try {
            audio = SmartAudioFactory.getInstance().fromInputStream(audioStream, this.getDefaultAudioFormat());
        }
        catch (IOException e) {
            throw new AsrException("\u8bfb\u53d6\u97f3\u9891\u5f02\u5e38", e);
        }
        return this.recognize(audio, params);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R<AsrResult> recognize(Audio audio, RecParams params) {
        R r;
        WhisperState state;
        block30: {
            R e4;
            block29: {
                R e22;
                block28: {
                    R r2;
                    block27: {
                        state = null;
                        StringBuilder text = new StringBuilder();
                        try {
                            WhisperParams whisperParams = (WhisperParams)params;
                            if (Objects.isNull(whisperParams.getParams().language)) {
                                R r3 = R.fail((Integer)1003, (String)"\u8bf7\u6307\u5b9a\u8bed\u8a00");
                                return r3;
                            }
                            if (!Language.EN.getCode().equals(whisperParams.getParams().language) && !this.whisper.isMultilingual(this.ctx)) {
                                r2 = R.fail((Integer)1002, (String)"\u5f53\u524d\u4e3a\u975e\u591a\u8bed\u79cd\u6a21\u578b\uff0c\u4ec5\u652f\u6301\u82f1\u8bed\u8bc6\u522b\uff0c\u6682\u4e0d\u652f\u6301\u5176\u4ed6\u8bed\u8a00\uff0c\u8bf7\u66f4\u6362\u591a\u8bed\u79cd\u6a21\u578b");
                                if (state == null) return r2;
                                break block27;
                            }
                            state = (WhisperState)this.statePool.borrowObject();
                            int result = this.whisper.fullWithState(this.ctx, state, whisperParams.getParams(), audio.getData(), audio.getData().length);
                            if (result != 0) {
                                e22 = R.fail((Integer)1000, (String)("Transcription failed with code " + result));
                                if (state == null) return e22;
                                break block28;
                            }
                            int numSegments = this.whisper.fullNSegmentsFromState(state);
                            if (numSegments <= 0) {
                                e4 = R.fail((Integer)1001, (String)"\u672a\u8bc6\u522b\u51fa\u6709\u6548\u8bed\u97f3");
                                if (state == null) return e4;
                                break block29;
                            }
                            ArrayList<AsrSegment> segments = new ArrayList<AsrSegment>(numSegments);
                            for (int i = 0; i < numSegments; ++i) {
                                long startTime = this.whisper.fullGetSegmentTimestamp0FromState(state, i);
                                long endTime = this.whisper.fullGetSegmentTimestamp1FromState(state, i);
                                String content = this.whisper.fullGetSegmentTextFromState(state, i);
                                segments.add(new AsrSegment(content, startTime * 10L, endTime * 10L));
                                text.append(content).append("\n");
                            }
                            r = R.ok((Object)new AsrResult(text.toString(), segments));
                            if (state == null) return r;
                            break block30;
                        }
                        catch (Exception e3) {
                            throw new AsrException(e3);
                        }
                    }
                    try {
                        this.statePool.returnObject(state);
                        return r2;
                    }
                    catch (Exception e22) {
                        log.warn("returnObject\u5931\u8d25", (Throwable)e22);
                    }
                    return r2;
                }
                try {
                    this.statePool.returnObject(state);
                    return e22;
                }
                catch (Exception e4) {
                    log.warn("returnObject\u5931\u8d25", (Throwable)e4);
                }
                return e22;
            }
            try {
                this.statePool.returnObject(state);
                return e4;
            }
            catch (Exception e5) {
                log.warn("returnObject\u5931\u8d25", (Throwable)e5);
            }
            return e4;
        }
        try {
            this.statePool.returnObject(state);
            return r;
        }
        catch (Exception e) {
            log.warn("returnObject\u5931\u8d25", (Throwable)e);
        }
        return r;
        finally {
            if (state != null) {
                try {
                    this.statePool.returnObject(state);
                }
                catch (Exception e) {
                    log.warn("returnObject\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public R<AsrResult> recognize(String audioPath) {
        return this.recognize(audioPath, (RecParams)new WhisperParams());
    }

    @Override
    public R<AsrResult> recognize(byte[] audioData) {
        return this.recognize(audioData, (RecParams)new WhisperParams());
    }

    @Override
    public R<AsrResult> recognize(InputStream audioStream) {
        return this.recognize(audioStream, (RecParams)new WhisperParams());
    }

    public WhisperGrammar parseGrammar(String grammarText) {
        try {
            return this.whisper.parseGrammar(grammarText);
        }
        catch (IOException e) {
            throw new AsrException(e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.fromFactory) {
            SpeechRecognizerFactory.removeFromCache(this.config.getModelEnum());
        }
        if (this.statePool != null) {
            this.statePool.close();
        }
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    public WhisperState getWhisperState() {
        try {
            return (WhisperState)this.statePool.borrowObject();
        }
        catch (Exception e) {
            throw new AsrException(e);
        }
    }

    private AudioFormat getDefaultAudioFormat() {
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, false);
    }

    @Override
    public void setFromFactory(boolean fromFactory) {
        this.fromFactory = fromFactory;
    }

    public boolean isFromFactory() {
        return this.fromFactory;
    }
}

