/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.translation.entity;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;

public abstract class BatchTensorList {
    private NDArray pastOutputIds;
    private NDArray pastAttentionMask;
    private NDList pastKeyValues;
    private long[] seqDimOrder;

    BatchTensorList() {
    }

    BatchTensorList(NDList list, long[] seqDimOrder) {
        this.seqDimOrder = seqDimOrder;
        this.pastOutputIds = (NDArray)list.get(0);
        this.pastAttentionMask = (NDArray)list.get(1);
        this.pastKeyValues = list.subNDList(2);
    }

    BatchTensorList(NDArray pastOutputIds, NDArray pastAttentionMask, NDList pastKeyValues, long[] seqDimOrder) {
        this.pastKeyValues = pastKeyValues;
        this.pastOutputIds = pastOutputIds;
        this.pastAttentionMask = pastAttentionMask;
        this.seqDimOrder = seqDimOrder;
    }

    public abstract BatchTensorList fromList(NDList var1, long[] var2);

    public abstract NDList getList();

    public long[] getSeqDimOrder() {
        return this.seqDimOrder;
    }

    public NDArray getPastOutputIds() {
        return this.pastOutputIds;
    }

    public void setPastOutputIds(NDArray pastOutputIds) {
        this.pastOutputIds = pastOutputIds;
    }

    public NDArray getPastAttentionMask() {
        return this.pastAttentionMask;
    }

    public void setPastAttentionMask(NDArray pastAttentionMask) {
        this.pastAttentionMask = pastAttentionMask;
    }

    public NDList getPastKeyValues() {
        return this.pastKeyValues;
    }

    public void setPastKeyValues(NDList pastKeyValues) {
        this.pastKeyValues = pastKeyValues;
    }

    public void setSeqDimOrder(long[] seqDimOrder) {
        this.seqDimOrder = seqDimOrder;
    }
}

