/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.objectdetection.model;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.objectdetection.config.DetectorModelConfig;
import cn.smartjavaai.objectdetection.enums.DetectorModelEnum;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import cn.smartjavaai.objectdetection.model.DetectorModel;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDetectionModelFactory {
    private static final Logger log = LoggerFactory.getLogger(ObjectDetectionModelFactory.class);
    private static volatile ObjectDetectionModelFactory instance;
    private static final ConcurrentHashMap<String, DetectorModel> modelMap;

    private ObjectDetectionModelFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectDetectionModelFactory getInstance() {
        if (instance != null) return instance;
        Class<ObjectDetectionModelFactory> clazz = ObjectDetectionModelFactory.class;
        synchronized (ObjectDetectionModelFactory.class) {
            if (instance != null) return instance;
            instance = new ObjectDetectionModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public DetectorModel getModel(DetectorModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum().name(), k -> {
            DetectorModel model = new DetectorModel();
            model.loadModel(config);
            return model;
        });
    }

    public DetectorModel getModel() {
        DetectorModelConfig config = new DetectorModelConfig();
        config.setModelEnum(DetectorModelEnum.YOLO11N);
        return this.getModel(config);
    }

    public void closeAll() {
        modelMap.values().forEach(DetectorModel::close);
    }

    static {
        modelMap = new ConcurrentHashMap();
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

