/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.objectdetection.model;

import ai.djl.MalformedModelException;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.common.utils.OpenCVUtils;
import cn.smartjavaai.objectdetection.config.DetectorModelConfig;
import cn.smartjavaai.objectdetection.criteria.CriteriaBuilderFactory;
import cn.smartjavaai.objectdetection.exception.DetectionException;
import cn.smartjavaai.objectdetection.utils.DetectorUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectorModel
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(DetectorModel.class);
    private ZooModel<Image, DetectedObjects> model;
    private ObjectPool<Predictor<Image, DetectedObjects>> predictorPool;

    public void loadModel(DetectorModelConfig config) {
        if (Objects.isNull((Object)config.getModelEnum())) {
            throw new DetectionException("\u672a\u914d\u7f6e\u6a21\u578b\u679a\u4e3e");
        }
        Criteria<Image, DetectedObjects> criteria = CriteriaBuilderFactory.createCriteria(config);
        try {
            this.model = criteria.loadModel();
            this.predictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.model));
            log.info("\u5f53\u524d\u8bbe\u5907: " + this.model.getNDManager().getDevice());
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new DetectionException("\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    public DetectionResponse detect(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new DetectionException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        Image image = null;
        try {
            image = ImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
        }
        catch (IOException e) {
            throw new DetectionException("\u56fe\u7247\u8f6c\u6362\u9519\u8bef", e);
        }
        DetectedObjects detectedObjects = this.detect(image);
        return DetectorUtils.convertToDetectionResponse(detectedObjects, image);
    }

    public void detectAndDraw(String imagePath, String outputPath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new DetectionException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try {
            Image img = ImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            DetectedObjects detectedObjects = this.detect(img);
            img.drawBoundingBoxes(detectedObjects);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            img.save((OutputStream)new FileOutputStream(Paths.get(outputPath, new String[0]).toAbsolutePath().toString()), "png");
        }
        catch (IOException e) {
            throw new DetectionException(e);
        }
    }

    public DetectionResponse detect(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            throw new DetectionException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
            return this.detect(image);
        }
        catch (IOException e) {
            throw new DetectionException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    public DetectionResponse detect(BufferedImage image) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            throw new DetectionException("\u56fe\u50cf\u65e0\u6548");
        }
        Image img = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)image));
        DetectedObjects detectedObjects = this.detect(img);
        return DetectorUtils.convertToDetectionResponse(detectedObjects, img);
    }

    public BufferedImage detectAndDraw(BufferedImage sourceImage) {
        if (!ImageUtils.isImageValid((BufferedImage)sourceImage)) {
            throw new DetectionException("\u56fe\u50cf\u65e0\u6548");
        }
        Image img = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)sourceImage));
        DetectedObjects detectedObjects = this.detect(img);
        img.drawBoundingBoxes(detectedObjects);
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            img.save((OutputStream)outputStream, "png");
            byte[] imageBytes = outputStream.toByteArray();
            return ImageIO.read(new ByteArrayInputStream(imageBytes));
        }
        catch (IOException e) {
            throw new DetectionException("\u5bfc\u51fa\u56fe\u7247\u5931\u8d25", e);
        }
    }

    private DetectedObjects detect(Image image) {
        Predictor predictor = null;
        try {
            predictor = (Predictor)this.predictorPool.borrowObject();
            DetectedObjects detectedObjects = (DetectedObjects)predictor.predict((Object)image);
            return detectedObjects;
        }
        catch (Exception e) {
            throw new DetectionException("\u76ee\u6807\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.predictorPool.returnObject((Object)predictor);
                    log.info("\u91ca\u653e\u8d44\u6e90");
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    try {
                        predictor.close();
                    }
                    catch (Exception ex) {
                        log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.predictorPool != null) {
            this.predictorPool.close();
        }
    }
}

