/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.vector.core;

import cn.smartjavaai.face.vector.config.MilvusConfig;
import cn.smartjavaai.face.vector.config.SQLiteConfig;
import cn.smartjavaai.face.vector.config.VectorDBConfig;
import cn.smartjavaai.face.vector.core.MilvusClient;
import cn.smartjavaai.face.vector.core.SQLiteClient;
import cn.smartjavaai.face.vector.core.VectorDBClient;
import cn.smartjavaai.face.vector.exception.VectorDBException;

public class VectorDBFactory {
    private VectorDBFactory() {
    }

    public static VectorDBClient createClient(VectorDBConfig config) {
        VectorDBClient client;
        if (config == null) {
            throw new VectorDBException("\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (config.getType()) {
            case SQLITE: {
                if (!(config instanceof SQLiteConfig)) {
                    throw new VectorDBException("SQLite\u7c7b\u578b\u9700\u8981SQLiteConfig\u914d\u7f6e");
                }
                client = new SQLiteClient((SQLiteConfig)config);
                break;
            }
            case MILVUS: {
                if (!(config instanceof MilvusConfig)) {
                    throw new VectorDBException("Milvus\u7c7b\u578b\u9700\u8981MilvusConfig\u914d\u7f6e");
                }
                client = new MilvusClient((MilvusConfig)config);
                break;
            }
            default: {
                throw new VectorDBException("\u4e0d\u652f\u6301\u7684\u5411\u91cf\u6570\u636e\u5e93\u7c7b\u578b: " + (Object)((Object)config.getType()));
            }
        }
        return client;
    }
}

