/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.utils;

import cn.smartjavaai.common.entity.DetectionInfo;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.Point;
import cn.smartjavaai.common.entity.face.FaceAttribute;
import cn.smartjavaai.common.entity.face.FaceInfo;
import cn.smartjavaai.common.entity.face.LivenessResult;
import cn.smartjavaai.common.enums.face.EyeStatus;
import cn.smartjavaai.common.enums.face.GenderType;
import cn.smartjavaai.common.enums.face.LivenessStatus;
import com.seeta.sdk.EyeStateDetector;
import com.seeta.sdk.FaceAntiSpoofing;
import com.seeta.sdk.GenderPredictor;
import com.seeta.sdk.SeetaImageData;
import com.seeta.sdk.SeetaPointF;
import com.seeta.sdk.SeetaRect;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Seetaface6Utils {
    public static double[][] facePoints(SeetaPointF[] pointFS) {
        double[][] pointsArray = new double[5][2];
        int i = 0;
        for (SeetaPointF point : pointFS) {
            pointsArray[i][0] = point.getX();
            pointsArray[i][1] = point.getY();
            ++i;
        }
        return pointsArray;
    }

    public static BufferedImage toBufferedImage(SeetaImageData seetaImageData) {
        int type = 5;
        BufferedImage image = new BufferedImage(seetaImageData.width, seetaImageData.height, type);
        image.getRaster().setDataElements(0, 0, seetaImageData.width, seetaImageData.height, seetaImageData.data);
        return image;
    }

    public static SeetaRect convertToSeetaRect(DetectionRectangle detectionRectangle) {
        SeetaRect seetaRect = new SeetaRect();
        seetaRect.x = detectionRectangle.getX();
        seetaRect.y = detectionRectangle.getY();
        seetaRect.width = detectionRectangle.getWidth();
        seetaRect.height = detectionRectangle.getHeight();
        return seetaRect;
    }

    public static SeetaPointF[] convertToSeetaPointF(List<Point> pointList) {
        return (SeetaPointF[])pointList.stream().map(p -> {
            SeetaPointF sp = new SeetaPointF();
            sp.x = p.getX();
            sp.y = p.getY();
            return sp;
        }).toArray(SeetaPointF[]::new);
    }

    public static LivenessStatus convertToLivenessStatus(FaceAntiSpoofing.Status status) {
        if (status == null) {
            return LivenessStatus.UNKNOWN;
        }
        switch (status) {
            case REAL: {
                return LivenessStatus.LIVE;
            }
            case SPOOF: {
                return LivenessStatus.NON_LIVE;
            }
            case FUZZY: {
                return LivenessStatus.UNKNOWN;
            }
            case DETECTING: {
                return LivenessStatus.DETECTING;
            }
        }
        return LivenessStatus.UNKNOWN;
    }

    public static GenderType convertToGenderType(GenderPredictor.GENDER gender) {
        if (gender == null) {
            return GenderType.UNKNOWN;
        }
        switch (gender) {
            case MALE: {
                return GenderType.MALE;
            }
            case FEMALE: {
                return GenderType.FEMALE;
            }
        }
        return GenderType.UNKNOWN;
    }

    public static EyeStatus convertToEyeStatus(EyeStateDetector.EYE_STATE eyeState) {
        if (eyeState == null) {
            return EyeStatus.UNKNOWN;
        }
        switch (eyeState) {
            case EYE_OPEN: {
                return EyeStatus.OPEN;
            }
            case EYE_CLOSE: {
                return EyeStatus.CLOSED;
            }
            case EYE_RANDOM: {
                return EyeStatus.NON_EYE_REGION;
            }
        }
        return EyeStatus.UNKNOWN;
    }

    public static DetectionResponse convertToFaceAttributeResponse(SeetaRect[] seetaResult, List<SeetaPointF[]> seetaPointFSList, List<FaceAttribute> faceAttributeList) {
        if (Objects.isNull(seetaResult) || seetaResult.length == 0) {
            return null;
        }
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        for (int i = 0; i < seetaResult.length; ++i) {
            SeetaRect rect = seetaResult[i];
            DetectionRectangle rectangle = new DetectionRectangle(rect.x, rect.y, rect.width, rect.height);
            FaceInfo faceInfo = new FaceInfo();
            if (seetaPointFSList != null && seetaPointFSList.size() > 0) {
                SeetaPointF[] seetaPointFS = seetaPointFSList.get(i);
                List keyPoints = Arrays.stream(seetaPointFS).map(p -> new Point(p.x, p.y)).collect(Collectors.toList());
                faceInfo.setKeyPoints(keyPoints);
            }
            if (faceAttributeList != null && faceAttributeList.size() > 0) {
                faceInfo.setFaceAttribute(faceAttributeList.get(i));
            }
            detectionInfoList.add(new DetectionInfo(rectangle, 0.0f, faceInfo));
        }
        return new DetectionResponse(detectionInfoList);
    }

    public static DetectionResponse convertToDetectionResponse(SeetaRect[] seetaResult, List<SeetaPointF[]> seetaPointFSList, List<LivenessStatus> livenessStatusList) {
        if (Objects.isNull(seetaResult) || seetaResult.length == 0) {
            return null;
        }
        DetectionResponse detectionResponse = new DetectionResponse();
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        for (int i = 0; i < seetaResult.length; ++i) {
            SeetaRect rect = seetaResult[i];
            SeetaPointF[] seetaPointFS = seetaPointFSList.get(i);
            DetectionRectangle rectangle = new DetectionRectangle(rect.x, rect.y, rect.width, rect.height);
            List keyPoints = Arrays.stream(seetaPointFS).map(p -> new Point(p.x, p.y)).collect(Collectors.toList());
            FaceInfo faceInfo = new FaceInfo(keyPoints);
            faceInfo.setLivenessStatus(new LivenessResult(livenessStatusList.get(i)));
            DetectionInfo detectionInfo = new DetectionInfo(rectangle, 0.0f, faceInfo);
            detectionInfoList.add(detectionInfo);
        }
        detectionResponse.setDetectionInfoList(detectionInfoList);
        return detectionResponse;
    }
}

