/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.utils;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Landmark;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import cn.smartjavaai.common.entity.DetectionInfo;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.Point;
import cn.smartjavaai.common.entity.face.FaceAttribute;
import cn.smartjavaai.common.entity.face.FaceInfo;
import cn.smartjavaai.common.entity.face.HeadPose;
import cn.smartjavaai.common.utils.BufferedImageUtils;
import cn.smartjavaai.common.utils.Graphics2DUtils;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.facedect.mtcnn.MtcnnBatchResult;
import com.seeta.sdk.SeetaPointF;
import com.seeta.sdk.SeetaRect;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public class FaceUtils {
    public static DetectionResponse convertToDetectionResponse(DetectedObjects detection, Image img) {
        if (Objects.isNull(detection) || Objects.isNull(detection.getProbabilities()) || detection.getProbabilities().isEmpty() || Objects.isNull(detection.items()) || detection.items().isEmpty()) {
            return null;
        }
        DetectionResponse detectionResponse = new DetectionResponse();
        List detectedObjectList = detection.items();
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        Iterator iterator = detectedObjectList.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            DetectedObjects.DetectedObject result = (DetectedObjects.DetectedObject)iterator.next();
            BoundingBox box = result.getBoundingBox();
            ArrayList keyPoints = new ArrayList();
            box.getBounds().getPath().forEach(point -> keyPoints.add(new Point(point.getX(), point.getY())));
            int x = (int)(box.getBounds().getX() * (double)img.getWidth());
            int y = (int)(box.getBounds().getY() * (double)img.getHeight());
            int width = (int)(box.getBounds().getWidth() * (double)img.getWidth());
            int height = (int)(box.getBounds().getHeight() * (double)img.getHeight());
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (x + width > img.getWidth()) {
                width = img.getWidth() - x;
            }
            if (y + height > img.getHeight()) {
                height = img.getHeight() - y;
            }
            DetectionRectangle rectangle = new DetectionRectangle(x, y, width, height);
            FaceInfo faceInfo = new FaceInfo(keyPoints);
            DetectionInfo detectionInfo = new DetectionInfo(rectangle, ((Double)detection.getProbabilities().get(index)).floatValue(), faceInfo);
            detectionInfoList.add(detectionInfo);
            ++index;
        }
        detectionResponse.setDetectionInfoList(detectionInfoList);
        return detectionResponse;
    }

    public static DetectionResponse convertToDetectionResponse(SeetaRect[] seetaResult, List<SeetaPointF[]> seetaPointFSList) {
        if (Objects.isNull(seetaResult) || seetaResult.length == 0) {
            return null;
        }
        DetectionResponse detectionResponse = new DetectionResponse();
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        for (int i = 0; i < seetaResult.length; ++i) {
            SeetaRect rect = seetaResult[i];
            SeetaPointF[] seetaPointFS = seetaPointFSList.get(i);
            DetectionRectangle rectangle = new DetectionRectangle(rect.x, rect.y, rect.width, rect.height);
            List keyPoints = Arrays.stream(seetaPointFS).map(p -> new Point(p.x, p.y)).collect(Collectors.toList());
            FaceInfo faceInfo = new FaceInfo(keyPoints);
            DetectionInfo detectionInfo = new DetectionInfo(rectangle, 0.0f, faceInfo);
            detectionInfoList.add(detectionInfo);
        }
        detectionResponse.setDetectionInfoList(detectionInfoList);
        return detectionResponse;
    }

    public static DetectionResponse featuresConvertToResponse(SeetaRect[] seetaResult, List<SeetaPointF[]> seetaPointFSList, List<float[]> featureList) {
        if (Objects.isNull(seetaResult) || seetaResult.length == 0) {
            return null;
        }
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        for (int i = 0; i < seetaResult.length; ++i) {
            SeetaRect rect = seetaResult[i];
            DetectionRectangle rectangle = new DetectionRectangle(rect.x, rect.y, rect.width, rect.height);
            FaceInfo faceInfo = new FaceInfo();
            if (seetaPointFSList != null && seetaPointFSList.size() > 0) {
                SeetaPointF[] seetaPointFS = seetaPointFSList.get(i);
                List keyPoints = Arrays.stream(seetaPointFS).map(p -> new Point(p.x, p.y)).collect(Collectors.toList());
                faceInfo.setKeyPoints(keyPoints);
            }
            if (featureList != null && featureList.size() > 0) {
                faceInfo.setFeature(featureList.get(i));
            }
            detectionInfoList.add(new DetectionInfo(rectangle, 0.0f, faceInfo));
        }
        return new DetectionResponse(detectionInfoList);
    }

    public static DetectionResponse featuresConvertToResponse(SeetaRect rect, SeetaPointF[] seetaPointFS, float[] feature) {
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        DetectionRectangle rectangle = new DetectionRectangle(rect.x, rect.y, rect.width, rect.height);
        FaceInfo faceInfo = new FaceInfo();
        List keyPoints = Arrays.stream(seetaPointFS).map(p -> new Point(p.x, p.y)).collect(Collectors.toList());
        faceInfo.setKeyPoints(keyPoints);
        faceInfo.setFeature(feature);
        detectionInfoList.add(new DetectionInfo(rectangle, 0.0f, faceInfo));
        return new DetectionResponse(detectionInfoList);
    }

    public static DetectionRectangle correctRect(DetectionRectangle rectangle, int imageWidth, int imageHeight) {
        int x = rectangle.getX();
        int y = rectangle.getY();
        int width = rectangle.getWidth();
        int height = rectangle.getHeight();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x + width > imageWidth) {
            width = imageWidth - x;
        }
        if (y + height > imageHeight) {
            height = imageHeight - y;
        }
        if (width <= 0 || height <= 0) {
            return null;
        }
        return new DetectionRectangle(x, y, width, height);
    }

    public static double[][] facePoints(List<Point> points) {
        double[][] pointsArray = new double[5][2];
        int i = 0;
        for (Point point : points) {
            pointsArray[i][0] = point.getX();
            pointsArray[i][1] = point.getY();
            ++i;
        }
        return pointsArray;
    }

    public static NDArray faceTemplate512x512(NDManager manager) {
        double[][] coord5point = new double[][]{{192.98138, 239.94708}, {318.90277, 240.1936}, {256.63416, 314.01935}, {201.26117, 371.41043}, {313.08905, 371.15118}};
        NDArray points = manager.create((double[][])coord5point);
        return points;
    }

    public static NDArray faceTemplate112x112(NDManager manager) {
        double[][] coord5point = new double[][]{{30.29459953, 51.69630051}, {65.53179932, 51.50139999}, {48.02519989, 71.73660278}, {33.54930115, 87.0}, {62.72990036, 87.0}};
        NDArray points = manager.create((double[][])coord5point);
        return points;
    }

    public static NDArray faceTemplate96x112(NDManager manager) {
        double[][] coord5point = new double[][]{{30.29459953, 51.69630051}, {65.53179932, 51.50139999}, {48.02519989, 71.73660278}, {33.54930115, 92.3655014}, {62.72990036, 92.20410156}};
        NDArray points = manager.create((double[][])coord5point);
        return points;
    }

    public static void drawBoxesWithFaceAttribute(BufferedImage sourceImage, DetectionResponse detectionResponse, String savePath) throws IOException {
        if (!BufferedImageUtils.isImageValid((BufferedImage)sourceImage)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        if (Objects.isNull(detectionResponse) || Objects.isNull(detectionResponse.getDetectionInfoList()) || detectionResponse.getDetectionInfoList().isEmpty()) {
            throw new FaceException("\u65e0\u76ee\u6807\u6570\u636e");
        }
        Graphics2D graphics = sourceImage.createGraphics();
        graphics.setColor(Color.RED);
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int stroke = 2;
        for (DetectionInfo detectionInfo : detectionResponse.getDetectionInfoList()) {
            DetectionRectangle rectangle = detectionInfo.getDetectionRectangle();
            graphics.setColor(Color.RED);
            graphics.drawRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            if (detectionInfo.getFaceInfo() != null && detectionInfo.getFaceInfo().getKeyPoints() != null && !detectionInfo.getFaceInfo().getKeyPoints().isEmpty()) {
                Graphics2DUtils.drawLandmarks((Graphics2D)graphics, (List)detectionInfo.getFaceInfo().getKeyPoints());
            }
            if (rectangle.getHeight() <= 60 || detectionInfo.getFaceInfo() == null || detectionInfo.getFaceInfo().getFaceAttribute() == null) continue;
            StringBuilder attrText = new StringBuilder();
            FaceAttribute faceAttribute = detectionInfo.getFaceInfo().getFaceAttribute();
            if (faceAttribute.getGenderType() != null) {
                attrText.append(faceAttribute.getGenderType().name()).append(" ");
            }
            if (faceAttribute.getAge() != null) {
                attrText.append(faceAttribute.getAge()).append("\u5c81").append(" ");
            }
            if (faceAttribute.getWearingMask() != null) {
                attrText.append(faceAttribute.getWearingMask() != false ? "\u6234\u53e3\u7f69" : "\u672a\u6234\u53e3\u7f69").append(" ");
            }
            if (faceAttribute.getLeftEyeStatus() != null && faceAttribute.getRightEyeStatus() != null) {
                attrText.append("\u773c\u775b:").append(faceAttribute.getLeftEyeStatus().name()).append("/").append(faceAttribute.getRightEyeStatus().name()).append(" ");
            }
            ArrayList<String> lines = new ArrayList<String>();
            if (faceAttribute.getGenderType() != null) {
                lines.add("\u6027\u522b: " + faceAttribute.getGenderType().name());
            }
            if (faceAttribute.getAge() != null) {
                lines.add("\u5e74\u9f84: " + faceAttribute.getAge());
            }
            if (faceAttribute.getWearingMask() != null) {
                lines.add("\u53e3\u7f69: " + (faceAttribute.getWearingMask() != false ? "\u662f" : "\u5426"));
            }
            if (faceAttribute.getLeftEyeStatus() != null && faceAttribute.getRightEyeStatus() != null) {
                lines.add("\u773c\u775b: " + faceAttribute.getLeftEyeStatus().name() + "/" + faceAttribute.getRightEyeStatus().name());
            }
            if (faceAttribute.getHeadPose() != null) {
                HeadPose pose = faceAttribute.getHeadPose();
                String pitch = pose.getPitch() != null ? String.valueOf(pose.getPitch().intValue()) : "-";
                String yaw = pose.getYaw() != null ? String.valueOf(pose.getYaw().intValue()) : "-";
                String roll = pose.getRoll() != null ? String.valueOf(pose.getRoll().intValue()) : "-";
                lines.add("\u59ff\u6001: P=" + pitch + " Y=" + yaw + " R=" + roll);
            }
            if (lines.isEmpty()) continue;
            Graphics2DUtils.drawMultilineTextWithBackground((Graphics2D)graphics, lines, (int)rectangle.getX(), (int)rectangle.getY());
        }
        graphics.dispose();
        ImageIO.write((RenderedImage)sourceImage, "png", new File(savePath));
    }

    public static float convertScoreToSimilarity(String metricType, float score) {
        switch (metricType.toUpperCase()) {
            case "IP": {
                return (score + 1.0f) / 2.0f;
            }
            case "L2": {
                return 1.0f / (1.0f + score);
            }
            case "COSINE": {
                return (score + 1.0f) / 2.0f;
            }
        }
        throw new IllegalArgumentException("Unsupported metricType: " + metricType);
    }

    public static Image cropFace(Image image, DetectionRectangle rectangle) {
        return image.getSubImage(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public static DetectedObjects toDetectedObjects(MtcnnBatchResult mtcnnBatchResult, int imageWidth, int imageHeight) {
        ArrayList<String> classNames = new ArrayList<String>();
        ArrayList<Double> probs = new ArrayList<Double>();
        ArrayList<Landmark> boxes = new ArrayList<Landmark>();
        NDArray boxesND = mtcnnBatchResult.boxes.get(0);
        NDArray probsND = mtcnnBatchResult.probs.get(0);
        NDArray pointsND = mtcnnBatchResult.points.get(0);
        if (pointsND != null) {
            pointsND = pointsND.toType(DataType.FLOAT64, false);
        }
        if (boxesND == null || probsND == null || pointsND == null) {
            return new DetectedObjects(classNames, probs, boxes);
        }
        long numBoxes = boxesND.getShape().get(0);
        int i = 0;
        while ((long)i < numBoxes) {
            NDArray box = boxesND.get(new long[]{i});
            NDArray prob = probsND.get(new long[]{i});
            NDArray pointND = pointsND.get(new long[]{i});
            float x1 = box.getFloat(new long[]{0L});
            float y1 = box.getFloat(new long[]{1L});
            float x2 = box.getFloat(new long[]{2L});
            float y2 = box.getFloat(new long[]{3L});
            double x = x1 / (float)imageWidth;
            double y = y1 / (float)imageHeight;
            double w = (x2 - x1) / (float)imageWidth;
            double h = (y2 - y1) / (float)imageHeight;
            ArrayList<ai.djl.modality.cv.output.Point> keyPoints = new ArrayList<ai.djl.modality.cv.output.Point>();
            double[] flatPoints = pointND.toDoubleArray();
            for (int p = 0; p < 5; ++p) {
                keyPoints.add(new ai.djl.modality.cv.output.Point(flatPoints[p * 2], flatPoints[p * 2 + 1]));
            }
            Landmark landmark = new Landmark(x, y, w, h, keyPoints);
            classNames.add("Face");
            probs.add(Double.valueOf(prob.getFloat(new long[0])));
            boxes.add(landmark);
            ++i;
        }
        return new DetectedObjects(classNames, probs, boxes);
    }
}

