/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.seetaface;

import cn.hutool.core.io.FileUtil;
import cn.hutool.setting.dialect.Props;
import cn.hutool.system.OsInfo;
import cn.hutool.system.SystemUtil;
import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.face.exception.FaceException;
import com.seeta.sdk.util.DllItem;
import com.seeta.sdk.util.LoadNativeCore;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLoader {
    private static final Logger log = LoggerFactory.getLogger(NativeLoader.class);
    private static Path seetaface6NativePath;
    private static final String SEETAFACE_LIB_DIR = "seetaface6";
    private static final String PROPERTIES_FILE_NAME = "dll.properties";
    private static volatile boolean isDllLoaded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadNativeLibraries(DeviceEnum device) {
        try {
            if (!isDllLoaded) {
                Class<NativeLoader> clazz = NativeLoader.class;
                synchronized (NativeLoader.class) {
                    if (isDllLoaded) return;
                    OsInfo osInfo = SystemUtil.getOsInfo();
                    if (!osInfo.isWindows() && !osInfo.isLinux()) {
                        throw new FaceException("\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301\uff1a" + osInfo.getName());
                    }
                    if (device != null && device.equals((Object)DeviceEnum.GPU) && !osInfo.getArch().contains("amd64") && !osInfo.getArch().contains("x86_64")) {
                        throw new FaceException("seetaface6 GPU\u6a21\u578b\u4e0d\u652f\u6301\u5f53\u524darch\uff1a" + osInfo.getArch());
                    }
                    seetaface6NativePath = Paths.get(Config.getCachePath(), SEETAFACE_LIB_DIR);
                    FileUtil.mkdir((Path)seetaface6NativePath);
                    log.debug("seetaface6\u4f9d\u8d56\u5e93\u8def\u5f84: " + seetaface6NativePath.toAbsolutePath().toString());
                    List<File> fileList = NativeLoader.getLibFiles(osInfo, device);
                    if (fileList != null && !fileList.isEmpty()) {
                        fileList.forEach(file -> System.load(file.getAbsolutePath()));
                    }
                    log.debug("seetaface6 \u4f9d\u8d56\u5e93\u52a0\u8f7d\u5b8c\u6bd5");
                    isDllLoaded = true;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
            log.debug("SeetaFace DLL is already loaded.");
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("Native library loading failed", e);
        }
    }

    private static List<File> getLibFiles(OsInfo osInfo, DeviceEnum deviceEnum) {
        try {
            String device = NativeLoader.getDevice(deviceEnum);
            log.debug("\u5f53\u524d\u8bbe\u5907\uff1a{}", (Object)device);
            ArrayList<DllItem> baseList = new ArrayList<DllItem>();
            ArrayList<DllItem> jniList = new ArrayList<DllItem>();
            InputStream propsInputStream = LoadNativeCore.class.getResourceAsStream(NativeLoader.getPropertiesPath());
            Props props = new Props();
            props.load(propsInputStream);
            String prefix = NativeLoader.getPrefix();
            props.forEach((keyObj, valuObj) -> {
                String key = (String)keyObj;
                String value = (String)valuObj;
                DllItem dllItem = new DllItem();
                dllItem.setKey(key);
                if (key.contains("base")) {
                    if (value.contains("tennis")) {
                        dllItem.setValue(prefix + "base/" + device + "/" + value);
                    } else {
                        dllItem.setValue(prefix + "base/" + value);
                    }
                    baseList.add(dllItem);
                } else {
                    dllItem.setValue(prefix + value);
                    jniList.add(dllItem);
                }
            });
            List<String> basePath = NativeLoader.getSortedPath(baseList);
            List<String> sdkPath = NativeLoader.getSortedPath(jniList);
            ArrayList<File> fileList = new ArrayList<File>();
            for (String baseSo : basePath) {
                fileList.add(NativeLoader.extractLibrary(baseSo));
            }
            for (String sdkSo : sdkPath) {
                fileList.add(NativeLoader.extractLibrary(sdkSo));
            }
            return fileList;
        }
        catch (Exception e) {
            throw new FaceException("\u62f7\u8d1d\u4f9d\u8d56\u5e93\u5931\u8d25", e);
        }
    }

    private static String getDevice(DeviceEnum deviceEnum) {
        String device = "CPU";
        if ("amd64".equals(NativeLoader.getArch()) && deviceEnum != null) {
            device = deviceEnum == DeviceEnum.GPU ? "GPU" : "CPU";
        }
        return device;
    }

    private static String getPrefix() {
        String arch = NativeLoader.getArch();
        String os = SystemUtil.getOsInfo().getName();
        if (os != null && os.toLowerCase().startsWith("windows")) {
            os = "/windows/";
        } else if (os != null && os.toLowerCase().startsWith("linux")) {
            os = "/linux/";
        } else {
            return null;
        }
        return "/seetaface6" + os + arch + "/";
    }

    private static String getArch() {
        String arch = SystemUtil.getOsInfo().getArch().toLowerCase();
        if (arch.startsWith("amd64") || arch.startsWith("x86_64") || arch.startsWith("x86-64") || arch.startsWith("x64")) {
            arch = "amd64";
        } else if (arch.contains("aarch")) {
            arch = "aarch64";
        } else if (arch.contains("arm")) {
            arch = "arm";
        }
        return arch;
    }

    private static String getPropertiesPath() {
        return NativeLoader.getPrefix() + PROPERTIES_FILE_NAME;
    }

    private static File extractLibrary(String libPath) throws IOException {
        String resourcePath = libPath;
        try (InputStream in = NativeLoader.class.getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new FileNotFoundException(resourcePath);
            }
            Path path = Paths.get(resourcePath, new String[0]);
            String fileName = path.getFileName().toString();
            Path targetPath = seetaface6NativePath.resolve(fileName);
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.copy(in, targetPath, StandardCopyOption.REPLACE_EXISTING);
                log.debug("copy target path success: {}", (Object)targetPath.toAbsolutePath());
                if (!SystemUtil.getOsInfo().getName().toLowerCase().contains("win")) {
                    targetPath.toFile().setExecutable(true);
                }
            }
            File file = targetPath.toFile();
            return file;
        }
    }

    private static List<String> getSortedPath(List<DllItem> list) {
        return list.stream().sorted(Comparator.comparing(dllItem -> {
            int i = dllItem.getKey().lastIndexOf(".") + 1;
            String substring = dllItem.getKey().substring(i);
            return Integer.valueOf(substring);
        })).map(DllItem::getValue).collect(Collectors.toList());
    }

    static {
        isDllLoaded = false;
    }
}

